/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml;

import it.infn.cnaf.voms.saml.SAMLAssertionFactory;
import it.infn.cnaf.voms.saml.SAMLResponseFactory;
import it.infn.cnaf.voms.saml.SecurityContextHelper;
import it.infn.cnaf.voms.saml.exceptions.IssuerPeerMismatchException;
import it.infn.cnaf.voms.saml.exceptions.UnauthorizedQueryException;
import it.infn.cnaf.voms.saml.exceptions.UnknownAttributeException;
import it.infn.cnaf.voms.saml.exceptions.UnsupportedQueryException;
import it.infn.cnaf.voms.saml.exceptions.VersionMismatchException;
import it.infn.cnaf.voms.saml.exceptions.X509SubjectWrongNameIDFormatException;
import it.infn.cnaf.voms.saml.exceptions.X509SubjectWrongNameIDValueException;
import java.rmi.RemoteException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.glite.security.voms.admin.util.DNUtil;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSSAMLService {
    public static final String VOMS_SAML_FQAN_URI = "http://voms.forge.cnaf.infn.it/fqan";
    private static Logger logger = LoggerFactory.getLogger(VOMSSAMLService.class);
    private SAMLAssertionFactory sAMLAssertionFactory;
    private SAMLResponseFactory sAMLResponseFactory;
    private int maxAssertionLifetime;

    public VOMSSAMLService(SAMLAssertionFactory sAMLAssertionFactory, SAMLResponseFactory sAMLResponseFactory, int maxAssertionLifetime) {
        this.sAMLAssertionFactory = sAMLAssertionFactory;
        this.sAMLResponseFactory = sAMLResponseFactory;
        this.maxAssertionLifetime = maxAssertionLifetime;
    }

    public Response attributeQuery(AttributeQuery attributeQuery, HttpServletRequest httpServletRequest) throws RemoteException {
        try {
            SecurityContextHelper peerSecurityContext = new SecurityContextHelper(httpServletRequest);
            this.checkAttributeQuery(attributeQuery, peerSecurityContext);
            Assertion assertion = this.sAMLAssertionFactory.create(peerSecurityContext.getCertificate(), attributeQuery, this.maxAssertionLifetime);
            return this.sAMLResponseFactory.create(attributeQuery.getID(), assertion);
        }
        catch (Throwable exception) {
            logger.error(exception.getMessage());
            return this.sAMLResponseFactory.create(attributeQuery.getID(), exception);
        }
    }

    private void checkAttributeQuery(AttributeQuery attributeQuery, SecurityContextHelper peerSecurityContext) throws VersionMismatchException, X509SubjectWrongNameIDFormatException, X509SubjectWrongNameIDValueException, IssuerPeerMismatchException, UnauthorizedQueryException, UnsupportedQueryException, UnknownAttributeException {
        if (attributeQuery.getVersion() != SAMLVersion.VERSION_20) {
            throw new VersionMismatchException();
        }
        String subjectNameIDFormat = attributeQuery.getSubject().getNameID().getFormat();
        if (!subjectNameIDFormat.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")) {
            throw new X509SubjectWrongNameIDFormatException(subjectNameIDFormat);
        }
        String subjectNameIDValue = attributeQuery.getSubject().getNameID().getValue();
        if (!DNUtil.isRFC2253Conformant(subjectNameIDValue)) {
            throw new X509SubjectWrongNameIDValueException(subjectNameIDValue);
        }
        X500Principal subject = new X500Principal(subjectNameIDValue);
        X500Principal issuer = new X500Principal(attributeQuery.getIssuer().getValue());
        logger.debug("Received AttributeQuery issued by " + issuer.getName() + " for subject " + subjectNameIDValue);
    }
}

