/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml;

import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.glite.security.voms.admin.util.DNUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextHelper {
    private static Logger logger = LoggerFactory.getLogger(SecurityContextHelper.class);
    private X509Certificate[] certificateChain;

    public SecurityContextHelper(HttpServletRequest httpServletRequest) {
        this.certificateChain = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (this.certificateChain == null) {
            throw new Error("Not authenticated.");
        }
        logger.info("Authenticated subject " + DNUtil.getOpenSSLSubject(this.certificateChain[0].getSubjectX500Principal()));
    }

    public X509Certificate getCertificate() {
        return this.certificateChain[0];
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public X500Principal getX500Principal() {
        return this.certificateChain[0].getSubjectX500Principal();
    }

    public boolean is(X500Principal issuer) {
        return this.certificateChain[0].getSubjectX500Principal().equals(issuer);
    }
}

