/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml;

import it.infn.cnaf.voms.aa.VOMSAttributes;
import it.infn.cnaf.voms.aa.VOMSFQAN;
import it.infn.cnaf.voms.aa.VOMSGenericAttribute;
import it.infn.cnaf.voms.saml.emi.AttributeWizard;
import java.util.ArrayList;
import java.util.List;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.impl.AttributeBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;

public class SAMLAttributeSerializer {
    public static final String ATTRIBUTE_NAME_FORMAT = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
    public static final String FQAN_ATTRIBUTE_NAME = "http://voms.forge.cnaf.infn.it/fqan";
    public static final String AUTHZ_INTEROP_FQAN_ATTRIBUTE_NAME = "http://authz-interop.org/xacml/subject/voms-fqan";

    static Attribute serializeFQAN(List<VOMSFQAN> fqans) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        AttributeBuilder attributeBuilder = (AttributeBuilder)builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        Attribute fqansAttribute = attributeBuilder.buildObject();
        fqansAttribute.setName(AUTHZ_INTEROP_FQAN_ATTRIBUTE_NAME);
        fqansAttribute.setNameFormat(ATTRIBUTE_NAME_FORMAT);
        XSStringBuilder attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
        for (VOMSFQAN fqan : fqans) {
            XSString attributeValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            attributeValue.setValue(fqan.getFQAN());
            fqansAttribute.getAttributeValues().add(attributeValue);
        }
        return fqansAttribute;
    }

    static Attribute serializeGenericAttribute(VOMSGenericAttribute genericAttribute) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        AttributeBuilder attributeBuilder = (AttributeBuilder)builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        Attribute gaAttribute = attributeBuilder.buildObject();
        gaAttribute.setName(genericAttribute.getName());
        gaAttribute.setNameFormat(ATTRIBUTE_NAME_FORMAT);
        XSStringBuilder attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
        XSString attributeValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        attributeValue.setValue(genericAttribute.getValue());
        gaAttribute.getAttributeValues().add(attributeValue);
        return gaAttribute;
    }

    public static List<Attribute> serializeAllAttributes(VOMSAttributes attributes) {
        assert (attributes != null) : "Cannot serialize a NULL attribute!";
        ArrayList<Attribute> vomsSAMLAttributes = new ArrayList<Attribute>();
        String voName = VOMSConfiguration.instance().getVOName();
        vomsSAMLAttributes.add(AttributeWizard.createVOAttribute(voName));
        vomsSAMLAttributes.add(AttributeWizard.createGroupAttribute(attributes.getFqans()));
        for (VOMSFQAN f : attributes.getFqans()) {
            if (!f.isGroup()) continue;
            vomsSAMLAttributes.add(AttributeWizard.createPrimaryGroupAttribute(f));
            break;
        }
        vomsSAMLAttributes.add(AttributeWizard.createRoleAttribute(attributes.getFqans()));
        for (VOMSFQAN f : attributes.getFqans()) {
            if (!f.isRole()) continue;
            vomsSAMLAttributes.add(AttributeWizard.createPrimaryRoleAttribute(f));
            break;
        }
        vomsSAMLAttributes.add(SAMLAttributeSerializer.serializeFQAN(attributes.getFqans()));
        for (VOMSGenericAttribute ga : attributes.getGenericAttributes()) {
            vomsSAMLAttributes.add(SAMLAttributeSerializer.serializeGenericAttribute(ga));
        }
        return vomsSAMLAttributes;
    }
}

