/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml;

import it.infn.cnaf.voms.aa.VOMSAA;
import it.infn.cnaf.voms.aa.VOMSAttributeAuthority;
import it.infn.cnaf.voms.aa.VOMSAttributes;
import it.infn.cnaf.voms.aa.VOMSFQAN;
import it.infn.cnaf.voms.saml.SAMLAttributeSerializer;
import it.infn.cnaf.voms.saml.emi.AttributeWizard;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.util.DNUtil;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml2.core.impl.AttributeStatementBuilder;
import org.opensaml.saml2.core.impl.ConditionsBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.SubjectBuilder;
import org.opensaml.saml2.core.impl.SubjectConfirmationBuilder;
import org.opensaml.saml2.core.impl.SubjectConfirmationDataBuilder;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.SignatureBuilder;
import org.opensaml.xml.signature.impl.SignatureImpl;

public class SAMLAssertionFactory {
    private X509Certificate certificate;
    private PrivateKey privateKey;

    public SAMLAssertionFactory(X509Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    protected Assertion createAssertion(X509Certificate subjectCertificate, List<Attribute> attributes, int lifetime) throws SecurityException {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        X500Principal subject = subjectCertificate.getSubjectX500Principal();
        AssertionBuilder assertionBuilder = (AssertionBuilder)builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = assertionBuilder.buildObject();
        assertion.getNamespaceManager().registerNamespace(new Namespace("http://dci-sec.org/saml/profile/virtual-organization/1.0", "dci-sec"));
        assertion.setID("_" + UUID.randomUUID().toString());
        assertion.setIssueInstant(new DateTime());
        IssuerBuilder issuerBuilder = (IssuerBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer assertionIssuer = issuerBuilder.buildObject();
        assertionIssuer.setValue(this.certificate.getSubjectX500Principal().getName());
        assertionIssuer.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        assertion.setIssuer(assertionIssuer);
        SubjectBuilder subjectBuilder = (SubjectBuilder)builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject assertionSubject = subjectBuilder.buildObject();
        NameIDBuilder nameIDBuilder = (NameIDBuilder)builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameID = nameIDBuilder.buildObject();
        nameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        nameID.setValue(subject.getName());
        assertionSubject.setNameID(nameID);
        assertion.setSubject(assertionSubject);
        ConditionsBuilder conditionsBuilder = (ConditionsBuilder)builderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = conditionsBuilder.buildObject();
        conditions.setNotBefore(new DateTime());
        conditions.setNotOnOrAfter(new DateTime().plusMinutes(lifetime));
        assertion.setConditions(conditions);
        AttributeStatementBuilder attributeStatementBuilder = (AttributeStatementBuilder)builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement attributeStatement = attributeStatementBuilder.buildObject();
        attributeStatement.getAttributes().addAll(attributes);
        assertion.getAttributeStatements().add(attributeStatement);
        SubjectConfirmationBuilder subjectConfirmationBuilder = (SubjectConfirmationBuilder)builderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConfirmation = subjectConfirmationBuilder.buildObject();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        SubjectConfirmationDataBuilder subjectConfirmationDataBuilder = (SubjectConfirmationDataBuilder)builderFactory.getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        SubjectConfirmationData subjectConfirmationData = subjectConfirmationDataBuilder.buildObject();
        BasicX509Credential peerCredential = SecurityHelper.getSimpleCredential((X509Certificate)subjectCertificate, null);
        X509KeyInfoGeneratorFactory x509KeyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        x509KeyInfoGeneratorFactory.setEmitEntityCertificate(true);
        KeyInfoGeneratorManager keyInfoGeneratorManager = new KeyInfoGeneratorManager();
        keyInfoGeneratorManager.registerFactory((KeyInfoGeneratorFactory)x509KeyInfoGeneratorFactory);
        KeyInfoGeneratorFactory keyInfoGeneratorFactory = keyInfoGeneratorManager.getFactory((Credential)peerCredential);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        KeyInfo peerKeyInfo = keyInfoGenerator.generate((Credential)peerCredential);
        subjectConfirmationData.getUnknownXMLObjects().add(peerKeyInfo);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        assertion.getSubject().getSubjectConfirmations().add(subjectConfirmation);
        BasicX509Credential credential = SecurityHelper.getSimpleCredential((X509Certificate)this.certificate, (PrivateKey)this.privateKey);
        SignatureBuilder signatureBuilder = (SignatureBuilder)builderFactory.getBuilder(Signature.DEFAULT_ELEMENT_NAME);
        SignatureImpl assertionSignature = signatureBuilder.buildObject();
        assertionSignature.setSigningCredential((Credential)credential);
        assertionSignature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        assertionSignature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        KeyInfo serviceKeyInfo = keyInfoGenerator.generate((Credential)credential);
        assertionSignature.setKeyInfo(serviceKeyInfo);
        assertion.setSignature((Signature)assertionSignature);
        return assertion;
    }

    public Attribute findAttributeInQuery(AttributeQuery query, String attributeName) {
        for (Attribute a : query.getAttributes()) {
            if (!a.getName().equals(attributeName)) continue;
            return a;
        }
        return null;
    }

    public Assertion create(X509Certificate subjectCertificate, AttributeQuery attributeQuery, int lifetime) throws SecurityException {
        Attribute groupAttr;
        List<String> requestedVOs;
        String userDN = DNUtil.getBCasX500(attributeQuery.getSubject().getNameID().getValue());
        ArrayList<Attribute> vomsSAMLAttributes = new ArrayList<Attribute>();
        VOMSAttributeAuthority vomsAA = VOMSAA.getVOMSAttributeAuthority();
        VOMSAttributes attributes = null;
        String voName = VOMSConfiguration.instance().getVOName();
        if (attributeQuery.getAttributes().isEmpty()) {
            attributes = vomsAA.getAllVOMSAttributes(userDN);
            vomsSAMLAttributes.addAll(SAMLAttributeSerializer.serializeAllAttributes(attributes));
            return this.createAssertion(subjectCertificate, vomsSAMLAttributes, lifetime);
        }
        Attribute voAttr = this.findAttributeInQuery(attributeQuery, "http://dci-sec.org/saml/attribute/virtual-organization");
        if (voAttr != null && ((requestedVOs = AttributeWizard.attributeToListOfStrings(voAttr)).isEmpty() || requestedVOs.contains(voName))) {
            vomsSAMLAttributes.add(AttributeWizard.createVOAttribute(voName));
        }
        if ((groupAttr = this.findAttributeInQuery(attributeQuery, "http://dci-sec.org/saml/attribute/group")) != null) {
            List<String> requestedGroups = AttributeWizard.attributeToListOfStrings(groupAttr);
            attributes = requestedGroups.isEmpty() ? vomsAA.getVOMSAttributes(userDN) : vomsAA.getVOMSAttributes(userDN, requestedGroups);
            vomsSAMLAttributes.add(AttributeWizard.createGroupAttribute(attributes.getFqans()));
            Attribute pGroupAttr = this.findAttributeInQuery(attributeQuery, "http://dci-sec.org/saml/attribute/group");
            List<String> requestedPrimaryGroup = AttributeWizard.attributeToListOfStrings(pGroupAttr);
            if (requestedPrimaryGroup.isEmpty()) {
                vomsSAMLAttributes.add(AttributeWizard.createPrimaryGroupAttribute(attributes.getFqans().get(0)));
            } else {
                VOMSFQAN reqPrimGroup = VOMSFQAN.fromString(requestedPrimaryGroup.get(0));
                if (attributes.getFqans().contains(reqPrimGroup)) {
                    vomsSAMLAttributes.add(AttributeWizard.createPrimaryGroupAttribute(reqPrimGroup));
                }
            }
            Attribute roleAttr = this.findAttributeInQuery(attributeQuery, "http://dci-sec.org/saml/attribute/role");
            if (roleAttr != null) {
                List<String> requestedRoles = AttributeWizard.roleAttributeToFQAN(roleAttr);
                VOMSAttributes roleAttrs = vomsAA.getVOMSAttributes(userDN, requestedRoles);
                ListIterator<VOMSFQAN> iter = roleAttrs.getFqans().listIterator();
                while (iter.hasNext()) {
                    VOMSFQAN f = iter.next();
                    if (attributes.getFqans().contains(f.getGroupPartAsVOMSFQAN())) continue;
                    iter.remove();
                }
                if (roleAttrs.hasRoles()) {
                    vomsSAMLAttributes.add(AttributeWizard.createRoleAttribute(roleAttrs.getFqans()));
                    Attribute pRoleAttr = this.findAttributeInQuery(attributeQuery, "http://dci-sec.org/saml/attribute/role/primary");
                    List<String> requestedPrimaryRole = AttributeWizard.roleAttributeToFQAN(pRoleAttr);
                    if (requestedPrimaryRole.isEmpty()) {
                        vomsSAMLAttributes.add(AttributeWizard.createPrimaryRoleAttribute(roleAttrs.getFqans().get(0)));
                    } else {
                        VOMSFQAN reqPrimRole = VOMSFQAN.fromString(requestedPrimaryRole.get(0));
                        if (roleAttrs.getFqans().contains(reqPrimRole)) {
                            vomsSAMLAttributes.add(AttributeWizard.createPrimaryRoleAttribute(reqPrimRole));
                        }
                    }
                }
            }
        }
        return this.createAssertion(subjectCertificate, vomsSAMLAttributes, lifetime);
    }
}

