/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.aa.impl;

import it.infn.cnaf.voms.aa.VOMSAttributeAuthority;
import it.infn.cnaf.voms.aa.VOMSAttributes;
import it.infn.cnaf.voms.aa.impl.VOMSAttributesImpl;
import java.util.List;
import org.glite.security.voms.admin.persistence.dao.CertificateDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchCertificateException;
import org.glite.security.voms.admin.persistence.error.NoSuchUserException;
import org.glite.security.voms.admin.persistence.error.SuspendedCertificateException;
import org.glite.security.voms.admin.persistence.error.SuspendedUserException;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class VOMSAAImpl
implements VOMSAttributeAuthority {
    protected void checkCertificateValidity(String dn, String ca) {
        assert (dn != null) : "Please specify a DN for the certificate!";
        CertificateDAO dao = CertificateDAO.instance();
        Certificate cert = null;
        cert = ca == null ? dao.findByDN(dn) : dao.findByDNCA(dn, ca);
        if (cert == null) {
            throw new NoSuchCertificateException("User identified by '" + dn + "' " + (ca != null ? ",'" + ca + "' " : "") + "not found!");
        }
        VOMSUser user = cert.getUser();
        if (user.isSuspended()) {
            throw new SuspendedUserException("User identified by '" + dn + "' " + (ca != null ? ",'" + ca + "' " : "") + "is currently suspended!");
        }
        if (cert.isSuspended()) {
            throw new SuspendedCertificateException("Certificate '" + cert.getSubjectString() + ", " + cert.getCa().getSubjectString() + "' is currently suspended for the following reason: " + cert.getSuspensionReason());
        }
    }

    @Override
    public VOMSAttributes getAllVOMSAttributes(String dn) {
        this.checkCertificateValidity(dn, null);
        VOMSUser u = VOMSUserDAO.instance().findBySubject(dn);
        if (u == null) {
            throw new NoSuchUserException("User '" + dn + "' not found in database!");
        }
        return VOMSAttributesImpl.getAllFromUser(u);
    }

    @Override
    public VOMSAttributes getAllVOMSAttributes(String dn, String ca) {
        this.checkCertificateValidity(dn, ca);
        VOMSUser u = VOMSUserDAO.instance().findByDNandCA(dn, ca);
        if (u == null) {
            throw new NoSuchUserException("User '" + dn + ",'" + ca + "' not found in database!");
        }
        return VOMSAttributesImpl.getAllFromUser(u);
    }

    @Override
    public VOMSAttributes getVOMSAttributes(String dn) {
        this.checkCertificateValidity(dn, null);
        VOMSUser u = VOMSUserDAO.instance().findBySubject(dn);
        if (u == null) {
            throw new NoSuchUserException("User '" + dn + "' not found in database!");
        }
        return VOMSAttributesImpl.fromUser(u);
    }

    @Override
    public VOMSAttributes getVOMSAttributes(String dn, List<String> requestedFQANs) {
        this.checkCertificateValidity(dn, null);
        VOMSUser u = VOMSUserDAO.instance().findBySubject(dn);
        if (u == null) {
            throw new NoSuchUserException("User '" + dn + "' not found in database!");
        }
        return VOMSAttributesImpl.fromUser(u, requestedFQANs);
    }

    @Override
    public VOMSAttributes getVOMSAttributes(String dn, String ca) {
        this.checkCertificateValidity(dn, ca);
        VOMSUser u = VOMSUserDAO.instance().findByDNandCA(dn, ca);
        if (u == null) {
            throw new NoSuchUserException("User '" + dn + ",'" + ca + "' not found in database!");
        }
        return VOMSAttributesImpl.fromUser(u);
    }

    @Override
    public VOMSAttributes getVOMSAttributes(String dn, String ca, List<String> requestedFQANs) {
        this.checkCertificateValidity(dn, ca);
        VOMSUser u = VOMSUserDAO.instance().findByDNandCA(dn, ca);
        if (u == null) {
            throw new NoSuchUserException("User '" + dn + ",'" + ca + "' not found in database!");
        }
        return VOMSAttributesImpl.fromUser(u, requestedFQANs);
    }
}

