/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleOpaque;
import oracle.sql.ANYDATA;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;

public class OPAQUE
extends DatumWithConnection
implements OracleOpaque {
    OpaqueDescriptor descriptor;
    byte[] value;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Aug_23_13:33:58_PDT_2011";
    public static final boolean TRACE = false;

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, Connection connection, Object object) throws SQLException {
        if (opaqueDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61, "OPAQUE");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.descriptor = opaqueDescriptor;
        if (connection != null) {
            this.setPhysicalConnectionOf(connection);
        }
        if (object instanceof ANYDATA) {
            ANYDATA aNYDATA = (ANYDATA)object;
            byte[] byArray = new byte[aNYDATA.getImageSize()];
            aNYDATA.pickle(byArray, 0);
            this.value = byArray;
        } else if (object instanceof byte[]) {
            this.value = (byte[])object;
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        this.setPhysicalConnectionOf(connection);
        this.descriptor = opaqueDescriptor;
        this.value = null;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.descriptor.getName();
    }

    @Override
    public String stringValue() throws SQLException {
        String string;
        block10: {
            string = "OPAQUE";
            try {
                Method method;
                String string2 = null;
                Object object = this.toJdbc();
                Class<?> clazz = object.getClass();
                if (clazz.equals(this.getClass())) break block10;
                try {
                    method = clazz.getMethod("getStringVal", new Class[0]);
                    if (method.getDeclaringClass().equals(clazz)) {
                        string2 = (String)method.invoke(object, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2 == null) {
                    try {
                        method = clazz.getMethod("stringValue", new Class[0]);
                        if (method.getDeclaringClass() == clazz) {
                            string2 = (String)method.invoke(object, new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string2 != null) {
                    string = string + "(" + string2 + ")";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    @Override
    public OpaqueDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    @Override
    public void setDescriptor(OpaqueDescriptor opaqueDescriptor) {
        this.descriptor = opaqueDescriptor;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        return this.descriptor.toBytes(this, false);
    }

    @Override
    public Object getValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    @Override
    public byte[] getBytesValue() throws SQLException {
        return this.descriptor.toValue(this, false);
    }

    @Override
    public void setValue(byte[] byArray) throws SQLException {
        this.value = byArray;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    @Override
    public Map getMap() {
        try {
            return this.getInternalConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    @Override
    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    @Override
    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    @Override
    public Object toClass(Class clazz, Map map) throws SQLException {
        Object object = null;
        try {
            if (clazz == null || clazz == OPAQUE.class) {
                object = this;
            } else {
                ORAData oRAData = null;
                Object t = clazz.newInstance();
                if (!(t instanceof ORADataFactory)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                ORADataFactory oRADataFactory = (ORADataFactory)t;
                oRAData = oRADataFactory.create(this, 2007);
                object = oRAData;
            }
        }
        catch (InstantiationException instantiationException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IllegalAccessException illegalAccessException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return object;
    }

    @Override
    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    @Override
    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }
}

