/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Aug_23_13:33:58_PDT_2011";
    public static final boolean TRACE = false;

    T4CInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, n2, accessor);
    }

    @Override
    public boolean isNull() throws IOException {
        if (!this.statement.connection.useFetchSizeWithLongColumn) {
            return super.isNull();
        }
        boolean bl = false;
        try {
            int n2 = this.statement.currentRow;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= this.statement.validRows) {
                return true;
            }
            bl = this.accessor.isNull(n2);
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(int n2) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3 = -1;
            try {
                if (this.statement.connection.lifecycle == 1 || this.statement.connection.lifecycle == 2) {
                    n3 = this.accessor.readStream(this.resizableBuffer, this.initialBufferSize);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            catch (IOException iOException) {
                try {
                    ((T4CConnection)this.statement.connection).handleIOException(iOException);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw iOException;
            }
            return n3;
        }
    }
}

