/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OracleResultSetImpl
extends BaseResultSet {
    PhysicalConnection connection;
    OracleStatement statement;
    boolean explicitly_closed;
    boolean m_emptyRset;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Aug_23_13:33:58_PDT_2011";
    public static final boolean TRACE = false;

    OracleResultSetImpl(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        this.close_statement_on_close = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.internal_close(false);
            this.statement.totalRowsVisited = 0;
            if (this.close_statement_on_close) {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.explicitly_closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.explicitly_closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "wasNull");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "wasNull");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.statement.wasNullValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.explicitly_closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.statement.isOpen) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return new OracleResultSetMetaData(this.connection, this.statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.statement.wrapper == null ? this.statement : this.statement.wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement getOracleStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl = true;
            PhysicalConnection physicalConnection2 = this.statement.connection;
            if (this.explicitly_closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (physicalConnection2 == null || physicalConnection2.lifecycle != 1) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.statement.sqlKind.isPlsqlOrCall()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 166, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.closed) {
                return false;
            }
            ++this.statement.currentRow;
            ++this.statement.totalRowsVisited;
            if (this.statement.maxRows != 0 && this.statement.totalRowsVisited > this.statement.maxRows) {
                this.internal_close(false);
                --this.statement.currentRow;
                --this.statement.totalRowsVisited;
                return false;
            }
            if (this.statement.currentRow >= this.statement.validRows) {
                bl = this.close_or_fetch_from_next(false);
            }
            if (bl && physicalConnection2.useFetchSizeWithLongColumn) {
                this.statement.reopenStreams();
            }
            if (!bl) {
                --this.statement.currentRow;
                --this.statement.totalRowsVisited;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close_or_fetch_from_next(boolean bl) throws SQLException {
        if (bl) {
            this.internal_close(false);
            return false;
        }
        if (this.statement.gotLastBatch) {
            this.internal_close(false);
            return false;
        }
        this.statement.check_row_prefetch_changed();
        PhysicalConnection physicalConnection = this.statement.connection;
        if (physicalConnection.protocolId == 3) {
            this.sqlWarning = null;
        } else {
            if (this.statement.streamList != null) {
                while (this.statement.nextStream != null) {
                    try {
                        this.statement.nextStream.close();
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    this.statement.nextStream = this.statement.nextStream.nextStream;
                }
            }
            this.clearWarnings();
            physicalConnection.registerHeartbeat();
            physicalConnection.needLine();
        }
        PhysicalConnection physicalConnection2 = physicalConnection;
        synchronized (physicalConnection2) {
            try {
                this.statement.isExecuting = true;
                this.statement.fetch();
            }
            finally {
                this.statement.isExecuting = false;
            }
        }
        if (this.statement.validRows == 0) {
            this.internal_close(false);
            return false;
        }
        this.statement.currentRow = 0;
        this.statement.checkValidRowsStatus();
        return true;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.explicitly_closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.statement != null && this.statement.connection.protocolId != 3 && !this.statement.closed && this.statement.serverCursor) {
            if (this.statement.validRows < 1) {
                this.close_or_fetch_from_next(false);
            }
            if (this.statement.validRows > 0) {
                this.statement.currentRow = -1;
            } else {
                this.m_emptyRset = true;
            }
        }
        if (this.statement.connection.protocolId == 3 && this.statement.serverCursor) {
            SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.explicitly_closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return !this.isEmptyResultSet() && this.closed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.explicitly_closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getRow() == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.explicitly_closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "isLast");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.explicitly_closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.statement.totalRowsVisited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getBigDecimal(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n4 = this.statement.currentRow;
            if (n4 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getBigDecimal(n4, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getBoolean(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getByte(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getBytes(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getDate(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getDate(n3, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getDouble(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getFloat(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getInt(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getLong(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getNClob(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getNString(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getObject(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getObject(n3, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getROWID(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getShort(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getSQLXML(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getString(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getTime(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getTime(n3, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getTimestamp(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getTimestamp(n3, calendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getURL(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getARRAY(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getBFILE(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getBLOB(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getCHAR(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getCLOB(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getCursor(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getCustomDatum(n3, customDatumFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getDATE(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getINTERVALDS(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getINTERVALYM(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getNUMBER(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getOPAQUE(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getOracleObject(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getORAData(n3, oRADataFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getRAW(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getREF(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getROWID(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getSTRUCT(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getTIMESTAMPLTZ(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getTIMESTAMPTZ(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getTIMESTAMP(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getAsciiStream(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getBinaryStream(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getCharacterStream(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getNCharacterStream(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getUnicodeStream(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].getAuthorizationIndicator(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] privateGetBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = this.statement.currentRow;
            if (n3 < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.statement.lastIndex = n2;
            if (this.statement.streamList != null) {
                this.statement.closeUsedStreams(n2);
            }
            return this.statement.accessors[n2 - 1].privateGetBytes(n3);
        }
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.statement.setPrefetchInternal(n2, false, false);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getPrefetchInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internal_close(boolean bl) throws SQLException {
        if (this.closed) {
            return;
        }
        super.close();
        if (this.statement.gotLastBatch && this.statement.validRows == 0) {
            this.m_emptyRset = true;
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        try {
            physicalConnection.registerHeartbeat();
            physicalConnection.needLine();
            PhysicalConnection physicalConnection2 = physicalConnection;
            synchronized (physicalConnection2) {
                this.statement.closeQuery();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statement.endOfResultSet(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.statement.getColumnIndex(string);
        }
    }

    boolean isEmptyResultSet() {
        return this.m_emptyRset || !this.m_emptyRset && this.statement.gotLastBatch && this.statement.validRows == 0;
    }

    int getValidRows() {
        return this.statement.validRows;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

