/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.container.listeners;

import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VOListener implements LifeCycle.Listener
{
    INSTANCE;

    public static final Logger log;

    public void lifeCycleStarting(LifeCycle event) {
        WebAppContext ctxt = (WebAppContext)event;
        log.info("Starting VO {}...", (Object)ctxt.getInitParameter("VO_NAME"));
    }

    public void lifeCycleStarted(LifeCycle event) {
        WebAppContext ctxt = (WebAppContext)event;
        log.info("VO {} started.", (Object)ctxt.getInitParameter("VO_NAME"));
    }

    public void lifeCycleFailure(LifeCycle event, Throwable cause) {
        WebAppContext ctxt = (WebAppContext)event;
        log.error("VO {} encountered a fatal error: " + cause.getMessage(), (Object)ctxt.getInitParameter("VO_NAME"), (Object)cause);
    }

    public void lifeCycleStopping(LifeCycle event) {
        WebAppContext ctxt = (WebAppContext)event;
        log.info("Stopping VO {}...", (Object)ctxt.getInitParameter("VO_NAME"));
    }

    public void lifeCycleStopped(LifeCycle event) {
        WebAppContext ctxt = (WebAppContext)event;
        log.info("VO {} stopped.", (Object)ctxt.getInitParameter("VO_NAME"));
    }

    static {
        log = LoggerFactory.getLogger((String)"VO");
    }
}

