/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.container;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;
import org.italiangrid.voms.container.listeners.VOListener;
import org.italiangrid.voms.container.listeners.VOMSESListener;
import org.italiangrid.voms.status.VOMSStatusFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSAppProvider
extends AbstractLifeCycle
implements AppProvider {
    public static final String VOMSES_APP_KEY = "__vomses__";
    public static final String DEFAULT_TMP_PREFIX = "/var/tmp";
    public static final int DEFAULT_SCAN_INTERVAL_IN_SECONDS = 10;
    public static final String ORACLE_JAR_NAME = "ojdbc6.jar";
    private static final Logger log = LoggerFactory.getLogger(VOMSAppProvider.class);
    private String configurationDir;
    private String warFile;
    private String deploymentDir;
    private String hostname;
    private String port;
    private int scanIntervalInSeconds = 10;
    private Scanner scanner;
    private final Scanner.DiscreteListener scannerListener = new Scanner.DiscreteListener(){

        private String getBasename(String filename) {
            File f = new File(filename);
            return f.getName();
        }

        public void fileRemoved(String filename) throws Exception {
            VOMSAppProvider.this.stopVO(this.getBasename(filename));
        }

        public void fileChanged(String filename) throws Exception {
        }

        public void fileAdded(String filename) throws Exception {
            VOMSAppProvider.this.startVO(this.getBasename(filename));
        }
    };
    private DeploymentManager deploymentManager;
    private Map<String, App> vomsApps = new HashMap<String, App>();

    protected void confDirSanityChecks() {
        File confDirFile = new File(this.configurationDir);
        if (!confDirFile.exists()) {
            throw new IllegalArgumentException("Configuration dir does not exist: " + this.configurationDir);
        }
        if (!confDirFile.isDirectory()) {
            throw new IllegalArgumentException("Configuration dir is not a directory: " + this.configurationDir);
        }
    }

    protected List<String> getConfiguredVONames() {
        File[] voFiles;
        this.confDirSanityChecks();
        ArrayList<String> voNames = new ArrayList<String>();
        File confDirFile = new File(this.configurationDir);
        for (File f : voFiles = confDirFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            voNames.add(f.getName());
        }
        return voNames;
    }

    protected App createApp(String voName) {
        return new App(this.deploymentManager, (AppProvider)this, voName);
    }

    private boolean voNameIsValid(String voName) {
        String voConfDir = String.format("%s/%s", this.configurationDir, voName).replaceAll("/+", "/");
        File f = new File(voConfDir);
        return f.exists() && f.isDirectory();
    }

    public void startVOMSES() {
        log.debug("Request to start VOMSES webapp");
        App a = this.createApp(VOMSES_APP_KEY);
        if (a != null) {
            this.vomsApps.put(VOMSES_APP_KEY, a);
            this.deploymentManager.addApp(a);
        }
    }

    public void startVO(String voName) {
        log.debug("Request to start vo {}", (Object)voName);
        if (!this.voNameIsValid(voName)) {
            log.error("VO {} is not configured on this host!", (Object)voName);
            return;
        }
        App a = this.createApp(voName);
        if (a != null) {
            this.vomsApps.put(voName, a);
            this.deploymentManager.addApp(a);
        }
    }

    public void stopVO(String voName) {
        log.debug("Request to stop vo {}", (Object)voName);
        if (!this.voNameIsValid(voName)) {
            log.error("VO {} is not configured on this host!");
            return;
        }
        App a = this.vomsApps.remove(voName);
        if (a != null) {
            this.deploymentManager.removeApp(a);
        }
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    protected File getJettyTmpDirForVO(String vo) {
        String baseDirPath = String.format("%s/%s/%s", DEFAULT_TMP_PREFIX, "voms-webapp", vo).replaceAll("/+", "/");
        File basePath = new File(baseDirPath);
        if (!basePath.exists()) {
            basePath.mkdirs();
        }
        return basePath;
    }

    protected ContextHandler configureWebApp(String vo) {
        String contextPath = String.format("/voms/%s", vo);
        WebAppContext vomsWebappContext = new WebAppContext();
        vomsWebappContext.setContextPath(contextPath);
        vomsWebappContext.setTempDirectory(this.getJettyTmpDirForVO(vo));
        vomsWebappContext.setParentLoaderPriority(false);
        File webArchive = new File(this.warFile);
        if (webArchive.isDirectory()) {
            String webXMLPath = String.format("%s/WEB-INF/web.xml", webArchive.getAbsolutePath());
            vomsWebappContext.setDescriptor(webXMLPath);
            vomsWebappContext.setResourceBase(webArchive.getAbsolutePath());
        } else {
            vomsWebappContext.setWar(this.warFile);
        }
        vomsWebappContext.addServerClass("ch.qos.logback.");
        vomsWebappContext.addServerClass("org.slf4j.");
        vomsWebappContext.addSystemClass("oracle.");
        vomsWebappContext.setInitParameter("VO_NAME", vo);
        vomsWebappContext.setInitParameter("CONF_DIR", this.configurationDir);
        vomsWebappContext.setInitParameter("HOST", this.hostname);
        vomsWebappContext.setInitParameter("PORT", this.port);
        vomsWebappContext.setConnectorNames(new String[]{"voms-https"});
        vomsWebappContext.addLifeCycleListener((LifeCycle.Listener)VOListener.INSTANCE);
        return vomsWebappContext;
    }

    protected ContextHandler configureVOMSES() {
        String webappResourceDir = ((Object)((Object)this)).getClass().getClassLoader().getResource("status-webapp").toExternalForm();
        WebAppContext statusContext = new WebAppContext();
        statusContext.setContextPath("/");
        statusContext.setResourceBase(webappResourceDir);
        statusContext.setParentLoaderPriority(true);
        statusContext.setInitParameter("host", this.hostname);
        statusContext.setInitParameter("confdir", this.configurationDir);
        statusContext.setConnectorNames(new String[]{"voms-http", "voms-https"});
        VOMSStatusFilter f = new VOMSStatusFilter(this.deploymentManager, this.hostname, this.port);
        FilterHolder fh = new FilterHolder((Filter)f);
        statusContext.addFilter(fh, "/*", EnumSet.of(DispatcherType.FORWARD, DispatcherType.REQUEST));
        statusContext.setThrowUnavailableOnStartupException(true);
        statusContext.addLifeCycleListener((LifeCycle.Listener)new VOMSESListener());
        return statusContext;
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        ContextHandler webApp = null;
        if (app != null) {
            webApp = app.getOriginId().equals(VOMSES_APP_KEY) ? this.configureVOMSES() : this.configureWebApp(app.getOriginId());
        }
        return webApp;
    }

    public Map<String, App> getDeployedApps() {
        return this.vomsApps;
    }

    protected void doStart() throws Exception {
        log.debug("Starting VOMS App provider.");
        File scanDir = new File(this.deploymentDir);
        if (!scanDir.exists() || !scanDir.isDirectory()) {
            throw new IllegalArgumentException("VOMS Admin deployment dir does not exist or is not a directory: " + scanDir.getAbsolutePath());
        }
        this.scanner = new Scanner();
        this.scanner.setScanDirs(Collections.singletonList(scanDir));
        this.scanner.setScanInterval(this.scanIntervalInSeconds);
        this.scanner.setRecursive(false);
        this.scanner.setReportDirs(false);
        this.scanner.addListener((Scanner.Listener)this.scannerListener);
        this.startVOMSES();
        this.scanner.start();
    }

    protected void doStop() throws Exception {
        log.debug("Stopping VOMS App provider.");
        if (this.scanner != null) {
            this.scanner.stop();
            this.scanner.removeListener((Scanner.Listener)this.scannerListener);
            this.scanner = null;
        }
    }

    public String getConfigurationDir() {
        return this.configurationDir;
    }

    public void setConfigurationDir(String configurationDir) {
        this.configurationDir = configurationDir;
    }

    public String getWarFile() {
        return this.warFile;
    }

    public void setWarFile(String warFile) {
        this.warFile = warFile;
    }

    public String getDeploymentDir() {
        return this.deploymentDir;
    }

    public void setDeploymentDir(String deploymentDir) {
        this.deploymentDir = deploymentDir;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

