/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.container;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysconfigUtil {
    public static Logger log = LoggerFactory.getLogger(SysconfigUtil.class);
    public static final String SYSCONFIG_DEFAULT_FILE_PATH = "/etc/sysconfig/voms-admin";
    public static final String SYSCONFIG_CONF_DIR = "CONF_DIR";
    public static final String SYSCONFIG_STATUS_PORT = "VOMS_STATUS_PORT";
    public static final String DEFAULT_PREFIX = "/";
    public static final String PREFIX_PROP_NAME = "package.prefix";

    static synchronized Properties loadPackagingProperties() {
        Properties packagingProps = new Properties();
        try {
            packagingProps.load(SysconfigUtil.class.getClassLoader().getResourceAsStream("packaging.properties"));
        }
        catch (IOException e) {
            packagingProps = null;
            log.warn("Packaging properties not found in classloader... using default value for sysconfig location");
        }
        return packagingProps;
    }

    public static synchronized String getConfDir() {
        return String.format("%s/etc/voms-admin", SysconfigUtil.getInstallationPrefix());
    }

    public static synchronized String getInstallationPrefix() {
        Properties packagingProps = SysconfigUtil.loadPackagingProperties();
        if (packagingProps == null) {
            return DEFAULT_PREFIX;
        }
        if (packagingProps.getProperty(PREFIX_PROP_NAME) == null) {
            log.warn("No {} property found in packaging properties.", (Object)PREFIX_PROP_NAME);
            return DEFAULT_PREFIX;
        }
        return packagingProps.getProperty(PREFIX_PROP_NAME);
    }

    public static synchronized String getSysconfigFilePath() {
        String sysconfigFilePath = SYSCONFIG_DEFAULT_FILE_PATH;
        String prefix = SysconfigUtil.getInstallationPrefix();
        if (prefix != null) {
            sysconfigFilePath = String.format("%s/etc/sysconfig/voms-admin", prefix).replaceAll("/+", DEFAULT_PREFIX);
        } else {
            log.warn("Packaging properties do not specify package.prefix property... using default value for sysconfig location");
        }
        return sysconfigFilePath;
    }

    public static synchronized Properties loadSysconfig() {
        String sysconfigFilePath = SysconfigUtil.getSysconfigFilePath();
        Properties props = new Properties();
        try {
            FileReader sysconfigReader = new FileReader(sysconfigFilePath);
            props.load(sysconfigReader);
            return props;
        }
        catch (FileNotFoundException e) {
            log.error("Error opening VOMS Admin system configuration file " + sysconfigFilePath);
            throw new IllegalArgumentException("Error opening VOMS Admin system configuration file " + sysconfigFilePath, e);
        }
        catch (IOException e) {
            log.error("Error parsing VOMS Admin system configuration file /etc/sysconfig/voms-admin");
            throw new IllegalArgumentException("Error parsing VOMS Admin system configuration file " + sysconfigFilePath, e);
        }
    }
}

