/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.container;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.component.LifeCycle;
import org.italiangrid.utils.https.JettyRunThread;
import org.italiangrid.utils.https.SSLOptions;
import org.italiangrid.utils.https.ServerFactory;
import org.italiangrid.utils.https.impl.canl.CANLListener;
import org.italiangrid.voms.container.ConfigurationProperty;
import org.italiangrid.voms.container.SysconfigUtil;
import org.italiangrid.voms.container.VOMSAppProvider;
import org.italiangrid.voms.container.Version;
import org.italiangrid.voms.container.listeners.ServerListener;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Container {
    public static final Logger log = LoggerFactory.getLogger(Container.class);
    private static final String TAGLIBS_JAR_NAME = "org.apache.taglibs.standard.glassfish";
    public static final String CONF_FILE_NAME = "voms-admin-server.properties";
    public static final String DEFAULT_WAR = "/usr/share/webapps/voms-admin.war";
    public static final String DEFAULT_TMP_PREFIX = "/var/tmp";
    public static final String DEFAULT_DEPLOY_DIR = "/usr/share/voms-admin/vo.d";
    public static final String HTTP_CONNECTOR_NAME = "voms-http";
    public static final String HTTPS_CONNECTOR_NAME = "voms-https";
    public static final String HTTP_CONNECTOR_PORT = "8088";
    private static final String ARG_WAR = "war";
    private static final String ARG_CONFDIR = "confdir";
    private static final String ARG_DEPLOYDIR = "deploydir";
    private Options cliOptions;
    private CommandLineParser parser = new GnuParser();
    private Properties serverConfiguration;
    private String war;
    private String confDir;
    private String deployDir;
    private String host;
    private String port;
    private String statusPort;
    private String certFile;
    private String keyFile;
    private String trustDir;
    private long trustDirRefreshIntervalInMsec;
    private Server server;
    private DeploymentManager deploymentManager;
    private HandlerCollection handlers = new HandlerCollection();
    private ContextHandlerCollection contexts = new ContextHandlerCollection();

    protected File getJettyTmpDirForVO(String vo) {
        String baseDirPath = String.format("%s/%s/%s", DEFAULT_TMP_PREFIX, "voms-webapp", vo).replaceAll("/+", "/");
        File basePath = new File(baseDirPath);
        if (!basePath.exists()) {
            basePath.mkdirs();
        }
        return basePath;
    }

    protected SSLOptions getSSLOptions() {
        SSLOptions options = new SSLOptions();
        options.setCertificateFile(this.certFile);
        options.setKeyFile(this.keyFile);
        options.setTrustStoreDirectory(this.trustDir);
        options.setTrustStoreRefreshIntervalInMsec(this.trustDirRefreshIntervalInMsec);
        return options;
    }

    protected void confDirSanityChecks() {
        File confDirFile = new File(this.confDir);
        if (!confDirFile.exists() || !confDirFile.isDirectory()) {
            throw new IllegalArgumentException("VOMS Admin configuration directory does not exists or is not a directory: " + confDirFile.getAbsolutePath());
        }
    }

    protected List<String> getConfiguredVONames() {
        File[] voFiles;
        this.confDirSanityChecks();
        ArrayList<String> voNames = new ArrayList<String>();
        File confDirFile = new File(this.confDir);
        for (File f : voFiles = confDirFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            voNames.add(f.getName());
        }
        return voNames;
    }

    protected void configureDeploymentManager() {
        this.contexts.setServer(this.server);
        this.deploymentManager = new DeploymentManager();
        VOMSAppProvider provider = new VOMSAppProvider();
        provider.setConfigurationDir(this.confDir);
        provider.setDeploymentDir(this.deployDir);
        provider.setHostname(this.host);
        provider.setPort(this.port);
        provider.setWarFile(this.war);
        this.deploymentManager.addAppProvider((AppProvider)provider);
        this.deploymentManager.setContexts(this.contexts);
    }

    protected void addNameToHTTPSConnector() {
        for (Connector c : this.server.getConnectors()) {
            if (c.getPort() != Integer.parseInt(this.port)) continue;
            SslSelectChannelConnector conn = (SslSelectChannelConnector)c;
            conn.setName(HTTPS_CONNECTOR_NAME);
        }
    }

    protected void configureLocalHTTPConnector() {
        SelectChannelConnector conn = new SelectChannelConnector();
        conn.setHost("localhost");
        conn.setPort(Integer.parseInt(this.statusPort));
        conn.setName(HTTP_CONNECTOR_NAME);
        this.server.addConnector((Connector)conn);
    }

    protected void configureJettyServer() {
        SSLOptions options = this.getSSLOptions();
        CANLListener l = new CANLListener();
        X509CertChainValidatorExt validator = CertificateValidatorBuilder.buildCertificateValidator((String)options.getTrustStoreDirectory(), (ValidationErrorListener)l, (StoreUpdateListener)l, (long)options.getTrustStoreRefreshIntervalInMsec());
        int maxConnections = Integer.parseInt(this.getConfigurationProperty(ConfigurationProperty.MAX_CONNECTIONS));
        int maxRequestQueueSize = Integer.parseInt(this.getConfigurationProperty(ConfigurationProperty.MAX_REQUEST_QUEUE_SIZE));
        this.server = ServerFactory.newServer((String)this.host, (int)Integer.parseInt(this.port), (SSLOptions)this.getSSLOptions(), (X509CertChainValidatorExt)validator, (int)maxConnections, (int)maxRequestQueueSize);
        this.addNameToHTTPSConnector();
        this.configureLocalHTTPConnector();
        this.server.addLifeCycleListener((LifeCycle.Listener)new ServerListener());
        this.configureDeploymentManager();
        this.handlers.setHandlers(new Handler[]{this.contexts, new DefaultHandler()});
        this.server.setHandler((Handler)this.handlers);
        this.server.setDumpAfterStart(false);
        this.server.setDumpBeforeStop(false);
        this.server.setStopAtShutdown(true);
        this.server.addBean((Object)this.deploymentManager);
    }

    private void start() {
        JettyRunThread vomsService = new JettyRunThread(this.server);
        vomsService.start();
    }

    private void initOptions() {
        this.cliOptions = new Options();
        this.cliOptions.addOption(ARG_WAR, true, "The WAR used to start this server.");
        this.cliOptions.addOption(ARG_DEPLOYDIR, true, "The VOMS Admin deploy directory.");
        this.cliOptions.addOption(ARG_CONFDIR, true, "The configuration directory where VOMS configuration is stored.");
    }

    private void failAndExit(String errorMessage, Throwable t) {
        if (t != null) {
            System.err.format("%s: %s\n", errorMessage, t.getMessage());
        } else {
            System.err.println(errorMessage);
        }
        System.exit(1);
    }

    private void parseCommandLineOptions(String[] args) {
        try {
            CommandLine cmdLine = this.parser.parse(this.cliOptions, args);
            Properties sysconfigProperties = SysconfigUtil.loadSysconfig();
            String installationPrefix = SysconfigUtil.getInstallationPrefix();
            String defaultPrefixedWarPath = String.format("%s/%s", installationPrefix, DEFAULT_WAR).replaceAll("/+", "/");
            this.war = cmdLine.getOptionValue(ARG_WAR, defaultPrefixedWarPath);
            this.confDir = cmdLine.getOptionValue(ARG_CONFDIR);
            if (this.confDir == null) {
                this.confDir = sysconfigProperties.getProperty("CONF_DIR");
            }
        }
        catch (ParseException e) {
            this.failAndExit("Error parsing command line arguments", e);
        }
    }

    private String getConfigurationProperty(ConfigurationProperty prop) {
        return this.serverConfiguration.getProperty(prop.getPropertyName(), prop.getDefaultValue());
    }

    private void loadServerConfiguration(String configurationDir) {
        try {
            this.serverConfiguration = new Properties();
            String configurationPath = String.format("%s/%s", configurationDir, CONF_FILE_NAME).replaceAll("/+", "/");
            this.serverConfiguration.load(new FileReader(configurationPath));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading configuration:" + e.getMessage(), e);
        }
    }

    private void loadConfiguration() {
        this.confDir = SysconfigUtil.getConfDir();
        this.statusPort = SysconfigUtil.loadSysconfig().getProperty("VOMS_STATUS_PORT", HTTP_CONNECTOR_PORT);
        this.loadServerConfiguration(this.confDir);
        this.host = this.getConfigurationProperty(ConfigurationProperty.HOST);
        this.port = this.getConfigurationProperty(ConfigurationProperty.PORT);
        this.certFile = this.getConfigurationProperty(ConfigurationProperty.CERT);
        this.keyFile = this.getConfigurationProperty(ConfigurationProperty.KEY);
        this.trustDir = this.getConfigurationProperty(ConfigurationProperty.TRUST_ANCHORS_DIR);
        long refreshIntervalInSeconds = Long.parseLong(this.getConfigurationProperty(ConfigurationProperty.TRUST_ANCHORS_REFRESH_PERIOD));
        this.trustDirRefreshIntervalInMsec = TimeUnit.SECONDS.toMillis(refreshIntervalInSeconds);
        this.deployDir = String.format("%s/%s", SysconfigUtil.getInstallationPrefix(), DEFAULT_DEPLOY_DIR).replaceAll("/+", "/");
    }

    private void forceTaglibsLoading() {
        try {
            String classpath = System.getProperty("java.class.path");
            String[] entries = classpath.split(System.getProperty("path.separator"));
            if (entries.length == 1) {
                JarFile f = new JarFile(entries[0]);
                Attributes attrs = f.getManifest().getMainAttributes();
                Attributes.Name n = new Attributes.Name("Class-Path");
                String jarClasspath = attrs.getValue(n);
                String[] jarEntries = jarClasspath.split(" ");
                boolean taglibsFound = false;
                for (String e : jarEntries) {
                    if (!e.contains(TAGLIBS_JAR_NAME)) continue;
                    taglibsFound = true;
                    ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                    File taglibsJar = new File(e);
                    URLClassLoader newClassLoader = new URLClassLoader(new URL[]{taglibsJar.toURI().toURL()}, currentClassLoader);
                    Thread.currentThread().setContextClassLoader(newClassLoader);
                }
                if (!taglibsFound) {
                    throw new RuntimeException("Error configuring taglibs classloading!");
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public Container(String[] args) {
        this.forceTaglibsLoading();
        try {
            this.initOptions();
            this.parseCommandLineOptions(args);
            this.configureLogging();
        }
        catch (Throwable t) {
            System.err.println("Error starting voms-admin server: " + t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
        try {
            this.loadConfiguration();
            this.logStartupConfiguration();
            this.configureJettyServer();
            this.start();
        }
        catch (Throwable t) {
            log.error("Error starting voms-admin server: " + t.getMessage(), t);
            System.exit(1);
        }
    }

    private void logStartupConfiguration() {
        log.info("VOMS Admin version {}.", (Object)Version.version());
        log.info("Binding on: {}:{}", (Object)this.host, (Object)this.port);
        log.info("HTTP status handler listening on: {}", (Object)this.statusPort);
        log.info("Service credentials: {}, {}", (Object)this.certFile, (Object)this.keyFile);
        log.info("Trust anchors directory: {}", (Object)this.trustDir);
        log.info("Trust anchors directory refresh interval (in minutes): {}", (Object)TimeUnit.MILLISECONDS.toMinutes(this.trustDirRefreshIntervalInMsec));
        log.info("Web archive location: {}", (Object)this.war);
        log.info("Configuration dir: {}", (Object)this.confDir);
        log.info("Deployment dir: {}", (Object)this.deployDir);
        log.info("Max # of concurrent connections: {}", (Object)this.getConfigurationProperty(ConfigurationProperty.MAX_CONNECTIONS));
        log.info("Max request queue size: {}", (Object)this.getConfigurationProperty(ConfigurationProperty.MAX_REQUEST_QUEUE_SIZE));
    }

    private void configureLogging() {
        String loggingConf = String.format("%s/%s", this.confDir, "voms-admin-server.logback").replaceAll("/+", "/");
        File f = new File(loggingConf);
        if (!f.exists() || !f.canRead()) {
            log.error("Error loading logging configuration: {} does not exist or is not readable.");
            return;
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        try {
            configurator.doConfigure(loggingConf);
        }
        catch (JoranException e) {
            this.failAndExit("Error setting up the logging system", e);
        }
    }

    public static void main(String[] args) {
        new Container(args);
    }
}

