/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesException;
import org.apache.tiles.jsp.taglib.ContainerTagSupport;
import org.apache.tiles.jsp.taglib.PutAttributeTag;
import org.apache.tiles.jsp.taglib.PutAttributeTagParent;

public abstract class RenderTagSupport
extends ContainerTagSupport
implements PutAttributeTagParent {
    protected String preparer;
    protected boolean flush;
    protected boolean ignore;

    public String getPreparer() {
        return this.preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer;
    }

    public boolean isFlush() {
        return this.flush;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void release() {
        this.preparer = null;
        this.flush = false;
        this.ignore = false;
        super.release();
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        return this.isAccessAllowed() ? 2 : 0;
    }

    protected void execute() throws TilesException, JspException, IOException {
        if (this.preparer != null) {
            this.container.prepare(this.preparer, new Object[]{this.pageContext});
        }
        this.render();
        if (this.flush) {
            this.pageContext.getOut().flush();
        }
    }

    protected abstract void render() throws JspException, TilesException, IOException;

    public void processNestedTag(PutAttributeTag nestedTag) {
        Attribute attribute = new Attribute(nestedTag.getValue(), nestedTag.getRole(), Attribute.AttributeType.getType((String)nestedTag.getType()));
        this.attributeContext.putAttribute(nestedTag.getName(), attribute);
    }
}

