/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class HiLA {
    private static final Logger log = Logger.getLogger(HiLA.class);
    private static final String COREPOOLSIZE = "corepoolsize";
    private static final String MAXTHREADSSIZE = "maxthreads";
    private static final String THREADTIMEOUT = "threadtimeout";
    protected static final String WAITFORPENDINGTASKS = "waitforpendingtasks";
    private final ScheduledExecutorService daemonExecutor;
    private final ThreadPoolExecutor executor;
    private static HiLA theInstance = null;
    private final Preferences preferences = Preferences.userNodeForPackage(HiLA.class);

    private HiLA() {
        this.daemonExecutor = Executors.newScheduledThreadPool(this.preferences.getInt(COREPOOLSIZE, 5), new ThreadFactory(){
            int threadNum = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "HiLA Daemon Thread " + Integer.toString(this.threadNum++));
                t.setDaemon(true);
                return t;
            }
        });
        this.executor = new ThreadPoolExecutor(Math.max(5, this.preferences.getInt(COREPOOLSIZE, 5)), this.preferences.getInt(MAXTHREADSSIZE, 30), (long)this.preferences.getInt(THREADTIMEOUT, 10), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            int threadNum = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "HiLA Thread " + Integer.toString(this.threadNum++));
            }
        });
        this.executor.allowCoreThreadTimeOut(true);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HiLA.this.daemonExecutor.shutdown();
                if (HiLA.this.executor.isTerminated()) {
                    try {
                        log.info((Object)"Waiting for pending tasks to finish.");
                        HiLA.this.executor.shutdown();
                        HiLA.this.executor.awaitTermination(HiLA.this.preferences.getInt(HiLA.WAITFORPENDINGTASKS, 10), TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        log.error((Object)("Pending tasks not finished after " + HiLA.this.preferences.getInt(HiLA.WAITFORPENDINGTASKS, 10) + " seconds"), (Throwable)e);
                    }
                    finally {
                        HiLA.this.executor.shutdownNow();
                    }
                }
            }
        }));
    }

    public static synchronized ScheduledExecutorService getDaemonExecutor() {
        if (theInstance == null) {
            theInstance = new HiLA();
        }
        return HiLA.theInstance.daemonExecutor;
    }

    public static synchronized ExecutorService getExecutor() {
        if (theInstance == null) {
            theInstance = new HiLA();
        }
        return HiLA.theInstance.executor;
    }

    public static synchronized void shutdown() throws InterruptedException {
        if (theInstance == null) {
            return;
        }
        theInstance.shutdownInternal();
    }

    private void shutdownInternal() throws InterruptedException {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(this.preferences.getInt(WAITFORPENDINGTASKS, 10), TimeUnit.SECONDS)) {
            log.warn((Object)"There are still pending tasks.");
        }
    }
}

