/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Transfer
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Transfer.class);

    public Transfer() {
        this.inializeOptions();
    }

    private void inializeOptions() {
        this.options.addOption(OptionConstants.FORCE);
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.RECURSIVE);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        try {
            CommandLine cmdline = this.parser.parse(this.options, cmdArgs);
            if (cmdline.hasOption(OptionConstants.HELP.getArgName())) {
                this.printHelp(ctx);
                return;
            }
            if (cmdline.getArgList().size() == 3) {
                String srcString = (String)cmdline.getArgList().get(1);
                String dstString = (String)cmdline.getArgList().get(2);
                Location srcLoc = new Location(srcString);
                if (!srcLoc.isLocationOfType(File.class)) {
                    srcLoc = ctx.getCurrentLocation().getChildLocation(srcString);
                }
                if (!srcLoc.isLocationOfType(File.class)) {
                    log.error((Object)(srcString + " is not a File location."));
                }
                File srcFile = (File)srcLoc.locate(new Object[0]);
                Location dstLoc = new Location(dstString);
                if (!dstLoc.isLocationOfType(File.class)) {
                    dstLoc = ctx.getCurrentLocation().getChildLocation(dstString);
                }
                if (!dstLoc.isLocationOfType(File.class)) {
                    log.error((Object)(dstString + " is not a File location."));
                }
                File dstFile = (File)dstLoc.locate(new Object[0]);
                srcFile.transfer(dstFile, cmdline.hasOption(OptionConstants.FORCE.getArgName()), cmdline.hasOption(OptionConstants.RECURSIVE.getArgName()));
            } else {
                log.error((Object)"Need exactly two arguments.");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

