/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Submittable;
import eu.unicore.hila.job.jsdl.JSDLtoModel;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;

public class Submit
extends ShellCommandBase
implements ShellCommand {
    static final Logger log = Logger.getLogger(Submit.class);

    public Submit() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.JSDL);
        this.options.addOption(OptionConstants.SITE);
        OptionBuilder.withArgName((String)"Run");
        OptionBuilder.withLongOpt((String)"run");
        OptionBuilder.withDescription((String)"Run job right away.");
        OptionBuilder.hasArg((boolean)false);
        this.options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print help.");
        this.options.addOption(OptionBuilder.create((String)"h"));
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) {
        block19: {
            try {
                Submittable site;
                CommandLine cmdline = this.parser.parse(this.options, cmdArgs);
                if (cmdline.hasOption("h")) {
                    this.printHelp(ctx);
                    return;
                }
                JobModel jm = null;
                if (cmdline.hasOption("j")) {
                    String fileName = cmdline.getOptionValue("j");
                    File jsdlFile = new File(fileName);
                    if (!jsdlFile.isAbsolute()) {
                        jsdlFile = new File(ctx.getCurrentLocalDir(), fileName);
                    }
                    if (!jsdlFile.exists() || jsdlFile.isDirectory()) {
                        try {
                            ctx.getCs().printString("JSDL file does not exist or is a directory.");
                            ctx.getCs().printNewline();
                        }
                        catch (IOException e) {
                            log.info((Object)"JSDL file does not exist or is a directory.", (Throwable)e);
                        }
                    }
                    try {
                        JobDefinitionDocument jdd = JobDefinitionDocument.Factory.parse((File)jsdlFile);
                        jm = new JSDLtoModel((Object)jdd).getModel();
                    }
                    catch (XmlException e) {
                        log.error((Object)"Error parsing JSDL document.", (Throwable)e);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error opening JSDL document.", (Throwable)e);
                    }
                } else {
                    this.missingArg("j");
                    return;
                }
                if (jm.getTaskName() == null) {
                    jm.setTaskName("HiLA Shell 'submit' job submitted at " + Calendar.getInstance().getTime());
                }
                if ((site = this.determineSite(ctx, cmdline)) == null) {
                    log.error((Object)"No site given. I do not know where to submit to.");
                    return;
                }
                try {
                    Job task = site.submit(jm);
                    try {
                        ctx.getCs().printString(task.getLocation().toString());
                        ctx.getCs().printNewline();
                    }
                    catch (IOException e) {
                        log.error((Object)"Unable to print using jLine.", (Throwable)e);
                    }
                    if (task == null || !cmdline.hasOption("r")) break block19;
                    if (cmdline.hasOption("sync")) {
                        task.startSync(new File[0]);
                        break block19;
                    }
                    task.startASync(new File[0]);
                }
                catch (HiLAException e) {
                    log.error((Object)"Error during submission or start of job.", (Throwable)e);
                }
            }
            catch (ParseException e) {
                log.error((Object)"Commandline parsing failed. Not doing anything.", (Throwable)e);
            }
        }
    }

    @Override
    public String help() {
        StringBuilder sb = new StringBuilder();
        sb.append("Submit jobs to sites" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        sb.append(super.help());
        return sb.toString();
    }

    private Submittable determineSite(ShellContext ctx, CommandLine cmdline) {
        Submittable site = null;
        if (ctx.getCurrentLocation() != null && ctx.getCurrentLocation().isLocationOfType(Submittable.class)) {
            try {
                site = (Submittable)ctx.getCurrentLocation().locate(new Object[0]);
            }
            catch (HiLAException e) {
                log.error((Object)"Site not locatable, although it is the current location.", (Throwable)e);
            }
        }
        if (cmdline.hasOption("s")) {
            Location siteLocation = null;
            try {
                siteLocation = new Location(cmdline.getOptionValue("s"));
                site = (Submittable)siteLocation.locate(new Object[0]);
            }
            catch (HiLAException e) {
                log.error((Object)("Given site " + siteLocation + " cannot be located."), (Throwable)e);
            }
        }
        return site;
    }
}

