/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Task;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Status
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Status.class);

    public Status() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.LOG);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        try {
            CommandLine cmdLine = this.parser.parse(this.options, cmdArgs);
            if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
                this.printHelp(ctx);
                return;
            }
            List argList = cmdLine.getArgList();
            argList.remove(0);
            ArrayList<Location> taskLocations = new ArrayList<Location>();
            for (String taskLocStr : argList) {
                Location taskLoc = new Location(taskLocStr);
                if (!taskLoc.isAbsolute()) {
                    taskLoc = ctx.getCurrentLocation().getChildLocation(taskLocStr);
                }
                if (!taskLoc.isLocationOfType(Task.class)) {
                    log.warn((Object)("Location " + taskLocStr + " is not of type " + Task.class.getName()));
                    continue;
                }
                taskLocations.add(taskLoc);
            }
            for (Location location : taskLocations) {
                HiLAException e;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("locating " + location));
                }
                Task task = (Task)location.locate(new Object[0]);
                log.info((Object)"##########");
                log.info((Object)("Job " + task.getLocation()));
                log.info((Object)("Status: " + task.status()));
                if (cmdLine.hasOption(OptionConstants.LOG.getArgName())) {
                    if (task instanceof Job) {
                        Job cmpTask = (Job)task;
                        log.info((Object)cmpTask.getLog());
                    } else {
                        log.warn((Object)("Job log only supported by " + Job.class.getName()));
                    }
                }
                if ((e = task.getError()) == null) continue;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                log.info((Object)("Task error reason: " + sw.toString()));
            }
        }
        catch (ParseException e) {
            log.error((Object)"Command line could not be parsed.", (Throwable)e);
        }
    }
}

