/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class Run
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Run.class);

    public Run() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.APP_NAME);
        this.options.addOption(OptionConstants.APP_VERSION);
        this.options.addOption(OptionConstants.APP_EXECUTABLE);
        this.options.addOption(OptionConstants.APP_ARGUMENT);
        this.options.addOption(OptionConstants.SITE);
        OptionBuilder.withArgName((String)"wtime");
        OptionBuilder.withDescription((String)"Wall clock time.");
        OptionBuilder.hasArg((boolean)true);
        this.options.addOption(OptionBuilder.create((char)'w'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        InputStream is = null;
        try {
            Location siteLoc;
            CommandLine cl = this.parser.parse(this.options, cmdArgs);
            if (cl.hasOption(OptionConstants.HELP.getArgName())) {
                this.printHelp(ctx);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Locating site for Execution.");
            }
            Site executionSite = null;
            if (cl.hasOption(OptionConstants.SITE.getOpt())) {
                String siteLocStr = cl.getOptionValue(OptionConstants.SITE.getOpt());
                siteLoc = new Location(siteLocStr);
                if (!siteLoc.isLocationOfType(Site.class)) {
                    siteLoc = ctx.getCurrentLocation().getChildLocation(siteLocStr);
                }
                if (!siteLoc.isLocationOfType(Site.class)) {
                    log.error((Object)"Site location invalid.");
                    return;
                }
            } else {
                log.error((Object)"No site given for execution.");
                return;
            }
            executionSite = (Site)siteLoc.locate(new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating job model.");
            }
            JobModel jm = new JobModel();
            if (cl.hasOption(OptionConstants.APP_EXECUTABLE.getOpt())) {
                String aeStr = cl.getOptionValue(OptionConstants.APP_EXECUTABLE.getOpt());
                jm.setExecutable(aeStr);
            }
            if (cl.hasOption(OptionConstants.APP_ARGUMENT.getOpt())) {
                String[] arguments;
                for (String argument : arguments = cl.getOptionValues(OptionConstants.APP_ARGUMENT.getOpt())) {
                    jm.addArgument(argument);
                }
            }
            ResourcesType rt = ResourcesType.Factory.newInstance();
            if (cl.hasOption('w')) {
                String sWtime = cl.getOptionValue('w');
                int wtime = Integer.parseInt(sWtime);
                RangeValueType rv = rt.addNewIndividualCPUTime();
                rv.addNewExact().setDoubleValue((double)wtime);
            }
            jm.setResources(rt);
            if (jm.getTaskName() == null) {
                jm.setTaskName("HiLA Shell 'run' job submitted at " + Calendar.getInstance().getTime());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Submitting job.");
            }
            jm.setStdout("stdout");
            jm.setStderr("stderr");
            Job task = executionSite.submit(jm);
            task.startSync(new File[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for job to finish ...");
            }
            while (!this.isFinalState(task.status())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            eu.unicore.hila.grid.File stdout = task.getStdOut();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving stdout from " + stdout.getLocation()));
            }
            SimpleTransfer transfer = stdout.exportToStream((OutputStream)System.out);
            transfer.block();
        }
        catch (HiLAException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command line.", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Unable to close stream.", (Throwable)e);
            }
        }
    }

    private boolean isFinalState(TaskStatus status) {
        return status.equals((Object)TaskStatus.ABORTED) || status.equals((Object)TaskStatus.FAILED) || status.equals((Object)TaskStatus.SUCCESSFUL);
    }
}

