/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Mv
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Mv.class);

    public Mv() {
        this.initOptions();
    }

    private void initOptions() {
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.FORCE);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        CommandLine cmdLine;
        try {
            cmdLine = this.parser.parse(this.options, cmdArgs);
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse the command line.", (Throwable)e);
            return;
        }
        if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
            this.printHelp(ctx);
            return;
        }
        List argList = cmdLine.getArgList();
        argList.remove(0);
        if (argList.size() == 2) {
            Location srcLoc = new Location((String)argList.get(0));
            if (!srcLoc.isLocationOfType(File.class)) {
                srcLoc = ctx.getCurrentLocation().getChildLocation((String)argList.get(0));
            }
            if (!srcLoc.isLocationOfType(File.class)) {
                throw new HiLAException("Source is not a file.");
            }
            Location dstLoc = new Location((String)argList.get(1));
            if (!dstLoc.isLocationOfType(File.class)) {
                dstLoc = ctx.getCurrentLocation().getChildLocation((String)argList.get(1));
            }
            if (!dstLoc.isLocationOfType(File.class)) {
                throw new HiLAException("Destination is not a file.");
            }
            File src = (File)srcLoc.locate(new Object[0]);
            File dst = (File)dstLoc.locate(new Object[0]);
            src.moveTo(dst, cmdLine.hasOption(OptionConstants.FORCE.getArgName()));
        }
    }

    @Override
    public String help() {
        return "Move a file to a new location. Will only work within a storage. Use transfer for remote copy." + System.getProperty("line.separator") + System.getProperty("line.separator") + super.help();
    }
}

