/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class MkDir
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(MkDir.class);

    public MkDir() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        OptionBuilder.withArgName((String)"h");
        OptionBuilder.withDescription((String)"Print this help message.");
        OptionBuilder.withLongOpt((String)"help");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withArgName((String)"p");
        OptionBuilder.withDescription((String)"Create parent directories.");
        OptionBuilder.withLongOpt((String)"parents");
        this.options.addOption(OptionBuilder.create((String)"p"));
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        try {
            CommandLine cmdLine = this.parser.parse(this.options, cmdArgs);
            if (cmdLine.hasOption("h")) {
                this.printHelp(ctx);
                return;
            }
            boolean createParents = cmdLine.hasOption("p");
            List locations = cmdLine.getArgList();
            locations.remove(0);
            for (String locationString : locations) {
                Location loc = new Location(locationString);
                if (!loc.isLocationOfType(File.class)) {
                    loc = ctx.getCurrentLocation().getChildLocation(locationString);
                }
                if (!loc.isLocationOfType(File.class)) {
                    log.error((Object)(locationString + " is not a valid relative or absolute File location."));
                    continue;
                }
                File file = (File)loc.locate(new Object[0]);
                try {
                    if (file.mkdir(createParents)) {
                        log.info((Object)("Successfully created " + file.getLocation().toString()));
                        continue;
                    }
                    log.info((Object)("Unable to create directory " + file.getLocation().toString()));
                }
                catch (HiLAException e) {
                    log.error((Object)("Couldn't create directory: " + file.getLocation().toString()));
                }
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse the command line.", (Throwable)e);
        }
    }
}

