/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.log4j.Logger;

public class LLs
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(LLs.class);

    public LLs() {
        this.initializeOptions();
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        File[] lFiles = ctx.getCurrentLocalDir().listFiles();
        if (lFiles == null) {
            return;
        }
        for (File file : lFiles) {
            try {
                ctx.getCs().printString(file.getName());
                ctx.getCs().printNewline();
            }
            catch (IOException e) {
                log.info((Object)file.getName());
            }
        }
    }

    private void initializeOptions() {
        OptionBuilder.withArgName((String)"h");
        OptionBuilder.withDescription((String)"Help");
        OptionBuilder.withLongOpt((String)"help");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withArgName((String)"l");
        OptionBuilder.withDescription((String)"Details");
        this.options.addOption(OptionBuilder.create((String)"l"));
    }
}

