/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class GetMetadata
extends ShellCommandBase {
    private static final Logger log = Logger.getLogger(GetMetadata.class);

    public GetMetadata() {
        this.initializeOptions();
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        CommandLine cmdline = null;
        try {
            cmdline = this.parser.parse(this.options, cmdArgs);
            if (cmdline.hasOption(OptionConstants.HELP.getOpt())) {
                this.printHelp(ctx);
                return;
            }
            List arglist = cmdline.getArgList();
            arglist.remove(0);
            for (String sLoc : arglist) {
                try {
                    Location loc = new Location(sLoc);
                    Resource res = null;
                    try {
                        res = loc.locate(new Object[0]);
                    }
                    catch (HiLAException e) {
                        loc = ctx.getCurrentLocation().getChildLocation(sLoc);
                        res = loc.locate(new Object[0]);
                    }
                    Metadata md = res.getMetadata();
                    System.out.println(loc + " : ");
                    if (md == null) continue;
                    Set properties = md.getProperties();
                    if (cmdline.hasOption(OptionConstants.LIST.getOpt())) {
                        for (Object property : properties) {
                            System.out.println("  " + (String)property);
                        }
                        continue;
                    }
                    if (cmdline.hasOption(OptionConstants.PROPERTY.getOpt())) {
                        Object property;
                        String propArg = cmdline.getOptionValue(OptionConstants.PROPERTY.getOpt());
                        if (propArg == null) continue;
                        property = md.getData(propArg);
                        if (property != null) {
                            System.out.println(" " + propArg);
                            System.out.println("  " + property);
                            continue;
                        }
                        log.warn((Object)("Property " + propArg + " does not exist on resource " + loc));
                        continue;
                    }
                    for (Object property : properties) {
                        System.out.println(" " + (String)property);
                        System.out.println("  " + md.getData((String)property));
                    }
                }
                catch (HiLAException e) {
                    log.warn((Object)e);
                }
            }
            return;
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse commandline.", (Throwable)e);
            return;
        }
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.LIST);
        this.options.addOption(OptionConstants.PROPERTY);
    }
}

