/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationPatternException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Cp
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Cp.class);

    public Cp() {
        this.initializeOptions();
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        Location dstLoc;
        Location srcLoc;
        CommandLine cmdLine;
        try {
            cmdLine = this.parser.parse(this.options, cmdArgs);
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command line.", (Throwable)e);
            throw new HiLAException("Unable to parse command line.", (Throwable)e);
        }
        if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
            this.printHelp(ctx);
            return;
        }
        boolean recursive = cmdLine.hasOption(OptionConstants.RECURSIVE.getArgName());
        List argList = cmdLine.getArgList();
        argList.remove(0);
        if (argList.size() == 2) {
            srcLoc = new Location((String)argList.get(0));
            if (!srcLoc.isLocationOfType(File.class)) {
                srcLoc = ctx.getCurrentLocation().getChildLocation((String)argList.get(0));
            }
            if (!srcLoc.isLocationOfType(File.class)) {
                throw new HiLALocationPatternException("Location " + srcLoc.toString() + " is not a File location.");
            }
            dstLoc = new Location((String)argList.get(1));
            if (!dstLoc.isLocationOfType(File.class)) {
                dstLoc = ctx.getCurrentLocation().getChildLocation((String)argList.get(1));
            }
            if (!dstLoc.isLocationOfType(File.class)) {
                throw new HiLALocationPatternException("Location " + dstLoc.toString() + " is not a File location.");
            }
        } else {
            throw new HiLANotImplementedException("Multiple files cannot be copied yet.");
        }
        File src = (File)srcLoc.locate(new Object[0]);
        File dst = (File)dstLoc.locate(new Object[0]);
        src.copyTo(dst, cmdLine.hasOption(OptionConstants.FORCE.getArgName()), recursive);
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.FORCE);
        this.options.addOption(OptionConstants.RECURSIVE);
    }
}

