/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Cleanup
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Cleanup.class);

    public Cleanup() {
        this.initializeOptions();
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        try {
            CommandLine cmdLine = this.parser.parse(this.options, cmdArgs);
            if (cmdLine.hasOption(OptionConstants.HELP.getOpt())) {
                this.printHelp(ctx);
                return;
            }
            List taskLocations = cmdLine.getArgList();
            taskLocations.remove(0);
            ArrayList<Job> tasks = new ArrayList<Job>();
            for (String locationString : taskLocations) {
                Location taskLocation = new Location(locationString);
                if (!taskLocation.isLocationOfType(Job.class)) {
                    taskLocation = ctx.getCurrentLocation().getChildLocation(locationString);
                }
                if (taskLocation.isLocationOfType(Job.class)) {
                    tasks.add((Job)taskLocation.locate(new Object[0]));
                    continue;
                }
                try {
                    ctx.getCs().printString(locationString + " is not a location of type ComputeTask.");
                    ctx.getCs().printNewline();
                }
                catch (IOException e) {
                    log.warn((Object)(locationString + " is not a location of type ComputeTask."));
                }
            }
            for (Job computeTask : tasks) {
                List<File> exportFiles;
                if (cmdLine.hasOption(OptionConstants.EXPORT_ALL.getOpt())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporting all files from working directory of " + computeTask.getLocation()));
                    }
                    exportFiles = computeTask.getWorkingDirectory().ls();
                } else {
                    exportFiles = new ArrayList();
                    String[] exports = cmdLine.getOptionValues(OptionConstants.EXPORT.getOpt());
                    if (exports != null) {
                        for (String export : exports) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Exporting " + export + " from working directory of " + computeTask.getLocation()));
                            }
                            exportFiles.add((File)computeTask.getWorkingDirectory().getChild(export));
                        }
                    }
                }
                computeTask.cleanup(exportFiles.toArray(new File[0]));
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command line.", (Throwable)e);
        }
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.EXPORT);
        this.options.addOption(OptionConstants.EXPORT_ALL);
    }
}

