/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Cd
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Cd.class);

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLALocationSyntaxException {
        if (cmdArgs.length == 1) {
            try {
                ctx.getCs().printString("No home location defined.");
            }
            catch (IOException e) {
                log.error((Object)"jLine couldn't print message. Message was: \"No home location defined.\"", (Throwable)e);
            }
        } else if (cmdArgs.length == 2) {
            Location absLoc = new Location(cmdArgs[1]);
            try {
                Resource res = absLoc.locate(new Object[0]);
                if (res instanceof File) {
                    File file = (File)res;
                    if (!file.exists()) {
                        log.warn((Object)"Cannot cd into a non-existing directory.");
                        return;
                    }
                    if (!file.isDirectory()) {
                        log.warn((Object)"Cannot cd into ordinary files.");
                        return;
                    }
                }
                ctx.setCurrentLocation(absLoc);
                return;
            }
            catch (HiLAException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot locate location " + absLoc));
                }
                if (ctx.getCurrentLocation() != null) {
                    Location relLoc = null;
                    relLoc = cmdArgs[1].equals("..") ? ctx.getCurrentLocation().getParentLocation() : ctx.getCurrentLocation().getChildLocation(cmdArgs[1]);
                    try {
                        Resource res = relLoc.locate(new Object[0]);
                        if (res != null) {
                            if (res instanceof File) {
                                File file = (File)res;
                                if (!file.exists()) {
                                    log.warn((Object)"Cannot cd into a non-existing directory.");
                                    return;
                                }
                                if (!file.isDirectory()) {
                                    log.warn((Object)"Cannot cd into ordinary files.");
                                    return;
                                }
                            }
                            ctx.setCurrentLocation(relLoc);
                            return;
                        }
                    }
                    catch (HiLAException e2) {
                        log.error((Object)"Something is wrong with the given resource.", (Throwable)e2);
                    }
                }
                log.warn((Object)("Couldn't set new location as absolute or relative location. Current location still is " + ctx.getCurrentLocation()));
            }
        } else {
            log.error((Object)"Can only cd to a single location.");
        }
    }
}

