/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Cat
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Cat.class);

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        CommandLine cmdline = null;
        try {
            cmdline = this.parser.parse(this.options, cmdArgs);
            if (cmdline.hasOption(OptionConstants.HELP.getOpt())) {
                this.printHelp(ctx);
                return;
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command line", (Throwable)e);
            return;
        }
        List args = cmdline.getArgList();
        args.remove(0);
        if (args.size() == 0) {
            log.error((Object)"Nothing to cat");
            return;
        }
        for (String arg : args) {
            Location loc = null;
            try {
                loc = new Location(arg);
                if (!loc.isLocationOfType(File.class)) {
                    loc = ctx.getCurrentLocation().getChildLocation(arg);
                }
                if (!loc.isLocationOfType(File.class)) continue;
                try {
                    SimpleTransfer trsf = ((File)loc.locate(new Object[0])).exportToStream((OutputStream)System.out);
                    trsf.block();
                }
                catch (HiLAException e) {
                    log.error((Object)("Cating " + loc + " to console failed."), (Throwable)e);
                }
            }
            catch (HiLAException e) {
                log.error((Object)("Unable to handle location " + loc), (Throwable)e);
            }
        }
    }
}

