/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Alias
extends ShellCommandBase {
    private static final Logger log = Logger.getLogger(Alias.class);

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        Map<String, String> aliases = ctx.getAliases();
        try {
            CommandLine cmdLine = this.parser.parse(this.options, cmdArgs);
            List argList = cmdLine.getArgList();
            argList.remove(0);
            if (argList.size() > 2) {
                log.error((Object)"Don't know what to do with an argument list of size > 2.");
                return;
            }
            if (argList.size() == 2) {
                if (((String)argList.get(0)).endsWith("=")) {
                    aliases.put(((String)argList.get(0)).substring(0, ((String)argList.get(0)).length() - 1), (String)argList.get(1));
                }
            } else if (argList.size() == 1) {
                this.printAlias(aliases, (String)argList.get(0));
            } else if (argList.size() == 0) {
                for (String string : aliases.keySet()) {
                    this.printAlias(aliases, string);
                }
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command.", (Throwable)e);
        }
    }

    private void printAlias(Map<String, String> aliases, String string) {
        if (aliases.containsKey(string)) {
            System.out.println("alias " + string + "='" + aliases.get(string) + "'");
        } else {
            System.out.println("alias " + string + ": not found");
        }
    }
}

