import datetime
import logging

from storm.monitoring.sensor.api import sensor
from storm.monitoring.sensor.api import service_sensor
from storm.monitoring.sensor.api import metrics
from storm.monitoring.sensor.api import services
from storm.monitoring.sensor.api import measure
from storm.monitoring.sensor.service.logsize import file_check
from storm.monitoring.sensor.api import measures

import commands

class LogSizeSensor(service_sensor.ServiceSensor):

    def __init__(self, hostname, service_type):
        self.logger = logging.getLogger("storm_sensor.logsize")
        self.logger.info("creating an instance of LogSizeSensor")

        self.hostname = hostname
        self.metric_type = metrics.Metrics().log_size
        if service_type not in services.Services().get_services():
            msg = 'The specified servive type %s does not exist' % str(val)
            raise services.ServicesError(msg)
        self.service_type = service_type
        self.log_files = services.Services().get_log_files_for_service_type(self.service_type)
        self.service_name = services.Services().get_service_names_for_service_type(self.service_type)
        self.timestamp = ''
        self.measures = measures.Measures()

    def get_hostname(self):
        """Returns hostname information"""
        self.logger.info("getting hostname")
        return self.hostname

    def run(self):
        """Run sensor and save data"""
        self.logger.info("doing run")
        self.timestamp = datetime.datetime.now()
     
        if type(self.log_files) == list:
            for log_file in self.log_files:
                output = file_check.FileSize(filename=log_file)
                #print output.get_size().get_description(), self.service_type
                self.measures.add_measure(output.get_size())
        else:
            output = file_check.FileSize(filename=self.log_files)
            #print output.get_size().get_description(), self.service_type
            self.measures.add_measure(output.get_size())

        self.get_measures()

    def get_measures(self):
        """Returns measures"""
        self.logger.info("getting measures")
        return self.measures

    def get_timestamp(self):
        """Returns timestamp"""
        self.logger.info("getting timestamp")
        return self.timestamp

    def get_metric_type(self):
        """Returns metric type"""
        self.logger.info("getting metric type")
        return self.metric_type

    def get_storm_service_types(self):
        """Returns storm service types"""
        self.logger.info("getting storm service type")
        return self.service_type

    def is_storm_service(self):
        """Returns True or False"""
        self.logger.info("checking storm service")
        return services.Services().is_service(self.service_type)

    def is_service_running(self):
        """Returns True or False"""
        self.logger.info("checking service running")
        cmd = '/sbin/service ' + self.service_name + ' status'
        output=commands.getstatusoutput(cmd)
        if output[0] == 0:
            if 'is running' in output[1] or 'is RUNNING' in output[1] or 'OK' in output[1]:
                return True
            else:
                return False
        return False
