import exceptions
import os
import logging

from stat import *
from storm.monitoring.sensor.api import units
from storm.monitoring.sensor.api import measure

class FileSizeError(exceptions.Exception):
    pass

class FileSize(object):
    """Checks memory of a given system"""
         
    def __init__(self, filename=''):
        self.logger = logging.getLogger("storm_sensor.file_size")
        self.logger.info("creating an instance of FileSize")

        if filename == '':
            raise FileSizeError('Please specify a filename')
        elif os.path.exists(filename):
            size,unit = self.file_size(filename)
            self.size = measure.Measure(size, unit, filename)
        else:
            msg = '%s does not exist. ' % filename
            msg += 'Please verify that the service is installed.'
            raise FileSizeError(msg)
         
    def file_size(self, filename):
        """Returns the size of a file"""
        self.logger.info("getting file size")
        return int(os.path.getsize(filename)), units.Units().byte

    def get_size(self):
        self.logger.info("getting size")
        return self.size
