#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence. 
# You may obtain a copy of the Licence at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the Licence is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the Licence for the specific language governing 
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------

import sys
import exceptions
from wnodes.utils import wsocket

def print_list_header():
    '''Print List Header'''
    print 'Image Tag Details \n'

def print_image_tag_details(info):
    '''Print Image tag details'''
    if type(info) == dict:
        msg_info = []
        for key, value in info.items():
             msg_info.append((key, value[2]))
        
        msg_header = 'Name'
        
        key_len = [len(x) for x,y in msg_info]
        if max(key_len) < len(msg_header):
            a = len(msg_header) - max(key_len)
            msg_update = []
            for i, v in enumerate(msg_info):
                msg_new = ''
                if len(v[0]) < max(key_len)+a:
                    b = max(key_len) - len(v[0]) + a
                    msg_new = v[0] + ' '*b
                if msg_new == '':  
                    msg_update.append((v[0], v[1]))
                else:
                    msg_update.append((msg_new, v[1]))
        else:
            a = max(key_len) - len(msg_header)
            msg_header += ' '*a
            msg_update = []
            for i, v in enumerate(msg_info):
                msg_new = ''
                if len(v[0]) < max(key_len):
                    b = max(key_len) - len(v[0])
                    msg_new = v[0] + ' '*b
                if msg_new == '':
                    msg_update.append((v[0], v[1]))
                else:
                    msg_update.append((msg_new, v[1]))    
                     
        msg_header += ' arch'
        print msg_header
        for x in msg_update:
            print x[0],x[1]

class ConnectionError(exceptions.Exception):
    pass

class ListTags:

    def __init__(self, user_data):
        try:
            c = wsocket.Connection(user_data['nameserver']['ns_host'], \
                int(user_data['nameserver']['ns_port']))
            msg = {'list_image':
                [""]}
            self.images_tags = c.sendRequest(msg)
        except:
            err_msg = "Cannot get images tags from"
            err_msg += " host: %s" % user_data['nameserver']['ns_host']
            err_msg += " port: %s" % user_data['nameserver']['ns_port']
            err_msg += " error: %s %s %s" % sys.exc_info()[:]
            raise ConnectionError(err_msg)

    def get_tags(self):
        return self.images_tags
