#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence. 
# You may obtain a copy of the Licence at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the Licence is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the Licence for the specific language governing 
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------

import os
import exceptions

class NoCmdFound(exceptions.Exception):
    pass

def is_bin(cmd):
    '''Checks if the cmd is an executable'''

    return os.path.exists(cmd) and os.access(cmd, os.X_OK)


def is_cmd_valid(cmd):
    '''Checks if the cmd is valid'''

    fpath, fname = os.path.split(cmd)
    if fpath:
        if is_bin(cmd):
            return True, cmd
    else:
        for path in os.environ["PATH"].split(os.pathsep):
            tmp_cmd = os.path.join(path, cmd)
            if is_bin(tmp_cmd):
                return True, tmp_cmd
    return False, cmd


def get_cmd_name(cmd):
    valid, cmd_name = is_cmd_valid(cmd)
    if not valid:
        raise NoCmdFound('Unknown command %s' % cmd)

    return cmd_name
