#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence. 
# You may obtain a copy of the Licence at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the Licence is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the Licence for the specific language governing 
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------

import os
import commands
import exceptions
from wnodes.cli.utils import load_config
from wnodes.cli.utils import checks
from wnodes.cli.utils import server_errors
from wnodes.cli.utils import user

class DeleteImageError(exceptions.Exception):
    pass

class DeleteImage(object):
    def __init__(self, user_data, image_location):

        self.image_location = image_location
        self.cmd_name = 'curl'
        self.user_data = user_data

    def get_command(self, not_show=True):
        '''Gets command string'''
        if not_show == True:
            not_show_progress_meter = ' -s '
        else:
            not_show_progress_meter = ' -i '

        info_option = ' -i'
        delete_option = ' -X DELETE '

        map_value = load_config.UserConfigCommand().get_map()

        cacert = ''
        cert,key = user.set_cert_key(data=self.user_data['user'])
        if not '/' in cert:
            cert=os.getcwd()+'/'+cert
        if not '/' in key:
            key=os.getcwd()+'/'+key
        if cert == key:
            cacert = cert
        cert_option = (map_value['user_cert'] + ' ' +
            cert + ' ')
        key_option = (map_value['user_key'] + ' ' +
            key + ' ')

        cacert_option = ''
        if cacert != '':
            cacert_option = ('--cacert ' +
                cacert + ' ')

        capath_option = (map_value['ca_path'] + ' ' +
            self.user_data['server']['ca_path'] + ' ')

        content_type_option = ("-H 'Accept: " +
           self.user_data['content']['type'] + "' ")

        cmd = (self.cmd_name + not_show_progress_meter + info_option +
           delete_option +
           cacert_option + capath_option + cert_option + key_option +
           content_type_option + self.image_location)

        return cmd

    def set_cmd_name(self):
        self.cmd_name = checks.get_cmd_name(self.cmd_name)

    def run_command(self, not_show=True):
        '''Runs command'''
        self.set_cmd_name()
        cmd_output = commands.getstatusoutput(self.get_command(not_show=not_show))
        return cmd_output

    def get_output(self, not_show=True):
        '''Returns Images Information'''
        output = self.run_command(not_show=not_show)

        correct_values = []
        msg = ''

        if len(output) > 0 and output[0] == 0:
            values = output[1].split('\n')

            errors = server_errors.ServerErrors()
            for x in values:
                if x in errors.get_errors():
                    msg = x

            if msg == '':
                for y in errors.get_occi_errors():
                    if y in values[0]:
                        raise DeleteImageError(values[0].split(y)[1])
                for x in values[5:]:
                    correct_values.append(str(x))

        elif output[0] > 0:
            output = self.run_command(not_show=False)
            raise DeleteImageError(output[1][1:])

        return correct_values, msg

