/*
 * Decompiled with CFR 0.152.
 */
package org.glite.jobid;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class Jobid {
    String unique;
    String bkserver;
    int port;

    public Jobid() {
    }

    public Jobid(String bkserver, int port) {
        if (bkserver == null) {
            throw new IllegalArgumentException("Jobid bkserver");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Jobid port");
        }
        this.bkserver = bkserver.indexOf("https://") == -1 ? "https://" + bkserver : bkserver;
        this.port = port;
        MessageDigest digest = null;
        try {
            String hostname = "";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                System.err.println(ex);
            }
            digest = MessageDigest.getInstance("MD5");
            this.unique = hostname + bkserver + port + Calendar.getInstance().getTimeInMillis() + new Random().nextInt(999999);
            digest.update(this.unique.getBytes(), 0, this.unique.length());
            Base64 base64 = new Base64();
            byte[] tmp = base64.encode(digest.digest());
            this.unique = new String(tmp, 0, tmp.length - 2);
            this.unique = this.unique.replaceAll("/", "_");
            this.unique = this.unique.replaceAll("\\+", "-");
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println(ex);
            System.exit(-1);
        }
    }

    public Jobid(String bkserver, int port, String unique) {
        if (bkserver == null) {
            throw new IllegalArgumentException("Jobid bkserver");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Jobid port");
        }
        if (unique == null) {
            throw new IllegalArgumentException("Jobid unique");
        }
        this.bkserver = bkserver.indexOf("https://") == -1 ? "https://" + bkserver : bkserver;
        this.port = port;
        this.unique = unique;
    }

    public Jobid(String jobidString) {
        if (jobidString == null) {
            throw new IllegalArgumentException("Jobid jobidString");
        }
        int doubleSlashPosition = jobidString.indexOf("https://");
        if (doubleSlashPosition == -1) {
            throw new IllegalArgumentException("wrong jobid https");
        }
        int colonPosition = jobidString.indexOf(":", doubleSlashPosition + 8);
        if (colonPosition == -1) {
            throw new IllegalArgumentException("wrong jobid colon");
        }
        int dashAfterPort = jobidString.indexOf("/", colonPosition);
        String bkserverS = jobidString.substring(0, colonPosition);
        Integer portS = new Integer(jobidString.substring(colonPosition + 1, dashAfterPort));
        String uniqueS = jobidString.substring(dashAfterPort + 1, jobidString.length());
        this.bkserver = bkserverS;
        this.port = portS;
        this.unique = uniqueS;
    }

    public String getBkserver() {
        return this.bkserver;
    }

    public void setBkserver(String bkserver) {
        if (bkserver == null) {
            throw new IllegalArgumentException("Jobid bkserver");
        }
        this.bkserver = bkserver;
    }

    public String getUnique() {
        return this.unique;
    }

    public void setUnique(String unique) {
        if (unique == null) {
            throw new IllegalArgumentException("Jobid unique");
        }
        this.unique = unique;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port <= 0 || port >= 65536) {
            throw new IllegalArgumentException("Jobid port");
        }
        this.port = port;
    }

    public String toString() {
        return this.bkserver + ":" + this.port + "/" + this.unique;
    }
}

