/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.bouncycastle.util.encoders.Base64;

public class PlainStoreUtils {
    private String diskPath;
    private String suffix;
    private final List<String> srcLocations;
    private final List<String> wildcardLocations;
    private final List<URL> urlLocations;
    private List<URL> resolvedWildcardLocations;

    public PlainStoreUtils(String diskPath, String suffix, List<String> locations) {
        this.diskPath = diskPath;
        this.suffix = suffix;
        this.wildcardLocations = new ArrayList<String>();
        this.urlLocations = new ArrayList<URL>();
        this.resolvedWildcardLocations = new ArrayList<URL>();
        this.srcLocations = locations;
        for (String s : this.srcLocations) {
            try {
                URL u = new URL(s);
                this.urlLocations.add(u);
            }
            catch (MalformedURLException e) {
                this.wildcardLocations.add(s);
            }
        }
    }

    public File getCacheFile(URL url) throws URISyntaxException {
        File dir = new File(this.diskPath);
        byte[] src = url.toURI().toASCIIString().getBytes();
        byte[] encoded = Base64.encode((byte[])src);
        String filename = new String(encoded, CertificateUtils.ASCII) + this.suffix + ".der";
        return new File(dir, filename);
    }

    public void saveCacheFile(byte[] what, URL url) throws URISyntaxException, IOException {
        if (this.diskPath == null) {
            return;
        }
        File output = this.getCacheFile(url);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(output));
        ((OutputStream)os).write(what);
        ((OutputStream)os).close();
    }

    private void establishWildcardLocations(String wildcard) {
        File f = new File(wildcard);
        File base = f.getParentFile();
        Collection files = FileUtils.listFiles((File)base, (IOFileFilter)new WildcardFileFilter(f.getName()), null);
        for (File file : files) {
            try {
                this.resolvedWildcardLocations.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Can't convert File to URL?", e);
            }
        }
    }

    public void establishWildcardsLocations() {
        this.resolvedWildcardLocations.clear();
        for (String loc : this.wildcardLocations) {
            this.establishWildcardLocations(loc);
        }
    }

    public boolean isPresent(URL u) {
        return this.urlLocations.contains(u) || this.resolvedWildcardLocations.contains(u);
    }

    public List<URL> getResolvedWildcards() {
        return this.resolvedWildcardLocations;
    }

    public List<URL> getURLLocations() {
        return this.urlLocations;
    }

    public List<String> getLocations() {
        ArrayList<String> ret = new ArrayList<String>(this.srcLocations.size());
        ret.addAll(this.srcLocations);
        return ret;
    }
}

