/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers;

import eu.emi.security.authn.x509.helpers.JavaAndBCStyle;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class DNComparator {
    public static String preNormalize(String dn) {
        RDN[] rdns;
        try {
            rdns = IETFUtils.rDNsFromString((String)dn, (X500NameStyle)JavaAndBCStyle.INSTANCE);
        }
        catch (IllegalArgumentException e) {
            return dn;
        }
        X500NameBuilder builder = new X500NameBuilder((X500NameStyle)JavaAndBCStyle.INSTANCE);
        for (RDN rdn : rdns) {
            if (rdn.isMultiValued()) {
                AttributeTypeAndValue[] avas = rdn.getTypesAndValues();
                for (int j = 0; j < avas.length; ++j) {
                    avas[j] = DNComparator.normalizeAVA(avas[j]);
                }
                builder.addMultiValuedRDN(avas);
                continue;
            }
            AttributeTypeAndValue ava = rdn.getFirst();
            builder.addRDN(DNComparator.normalizeAVA(ava));
        }
        return JavaAndBCStyle.INSTANCE.toString(builder.build());
    }

    public static int getHashCode(String dn) {
        String norm = DNComparator.preNormalize(dn);
        return new X500Principal(norm).hashCode();
    }

    private static String upLowCase(String src) {
        char[] chars = src.toCharArray();
        StringBuilder ret = new StringBuilder(chars.length);
        for (char c : chars) {
            ret.append(Character.toLowerCase(Character.toUpperCase(c)));
        }
        return ret.toString();
    }

    private static AttributeTypeAndValue normalizeAVA(AttributeTypeAndValue orig) {
        if (orig.getType().equals((Object)BCStyle.DC) || orig.getType().equals((Object)BCStyle.EmailAddress)) {
            ASN1Encodable value = orig.getValue();
            if (value instanceof ASN1String) {
                ASN1String ia5Str = (ASN1String)value;
                String newValue = DNComparator.upLowCase(ia5Str.getString());
                return new AttributeTypeAndValue(orig.getType(), (ASN1Encodable)new DERIA5String(newValue));
            }
            return orig;
        }
        return orig;
    }
}

