/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.samlclient;

import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.XACMLPolicyCLIUtils;
import org.glite.authz.pap.ui.cli.samlclient.SAMLClientCLI;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.common.impl.ExtensionsBuilder;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.xacml.profile.saml.XACMLPolicyQueryType;
import org.opensaml.xacml.profile.saml.impl.XACMLPolicyQueryTypeImplBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;

public class SAMLClient
extends SAMLClientCLI {
    private static final String[] commandNameValues = new String[]{"test-client", "tc"};
    private static final String OPT_PDP = "pdp";
    private static final String OPT_PDP_DESCRIPTION = "Send a PDP query (otherwise a PAP query is sent).";
    private static final String DESCRIPTION = "Test client perfoming a PAP (default) or PDP query.";
    private static final String USAGE = "[options]";

    public SAMLClient() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_PDP_DESCRIPTION);
        options.addOption(OptionBuilder.create((String)OPT_PDP));
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        boolean isPAPQuery = true;
        if (commandLine.hasOption(OPT_PDP)) {
            isPAPQuery = false;
        }
        XACMLPolicyCLIUtils.initOpenSAMLAndAttributeWizard();
        XACMLPolicyQueryType query = SAMLClient.buildSamlXacmlQuery("IssuerString", isPAPQuery);
        Response response = this.samlClient.XACMLPolicyQuery(query);
        if (this.verboseMode) {
            System.out.println(XMLObjectHelper.toString((XMLObject)response));
        } else {
            System.out.println("Received response");
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }

    private static XACMLPolicyQueryType buildSamlXacmlQuery(String issuerString, boolean isPAPQuery) {
        XMLObjectBuilderFactory bf = Configuration.getBuilderFactory();
        XACMLPolicyQueryTypeImplBuilder builder = (XACMLPolicyQueryTypeImplBuilder)bf.getBuilder(XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20);
        XACMLPolicyQueryType policyQuery = builder.buildObject(XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20.getNamespaceURI(), XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20.getLocalPart(), XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20.getPrefix());
        IssuerBuilder issuerBuilder = (IssuerBuilder)bf.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(issuerString);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        policyQuery.setIssuer(issuer);
        policyQuery.setIssueInstant(new DateTime());
        if (isPAPQuery) {
            ExtensionsBuilder eBuilder = (ExtensionsBuilder)bf.getBuilder(new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md"));
            Extensions extensions = eBuilder.buildObject();
            policyQuery.setExtensions(extensions);
        }
        return policyQuery;
    }
}

