/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.common.xacml.wizard.XACMLWizard;
import org.glite.authz.pap.encoder.EncodingException;
import org.glite.authz.pap.encoder.PolicyFileEncoder;
import org.glite.authz.pap.ui.cli.CLIException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;
import org.glite.authz.pap.ui.cli.policymanagement.XACMLPolicyCLIUtils;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;

public class UpdatePolicy
extends PolicyManagementCLI {
    private static final String[] commandNameValues = new String[]{"update-policy-from-file", "upf"};
    private static final String DESCRIPTION = "Update the resource/action identified by <id> with the new resource/action defined in <file>.";
    private static final String USAGE = "[options] <id> <file>";
    private PolicyFileEncoder policyFileEncoder = new PolicyFileEncoder();
    private String alias = null;

    public UpdatePolicy() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    private int updatePolicy(String id, PolicyWizard policyWizard) throws RemoteException {
        if (!this.xacmlPolicyMgmtClient.hasPolicy(this.alias, id)) {
            System.out.println("Error: action id \"" + id + "\" does not exists.");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        PolicyType oldPolicy = this.xacmlPolicyMgmtClient.getPolicy(this.alias, id);
        policyWizard.setPolicyId(id);
        policyWizard.increaseVersion();
        boolean success = this.xacmlPolicyMgmtClient.updatePolicy(this.alias, oldPolicy.getVersion(), policyWizard.getXACML());
        if (!success) {
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }

    private int updatePolicySet(String id, PolicySetWizard policySetWizard) throws RemoteException {
        if (!this.xacmlPolicyMgmtClient.hasPolicySet(this.alias, id)) {
            System.out.println("Error: resource id \"" + id + "\" does not exists.");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        List<PolicyWizard> policyWizardList = policySetWizard.getPolicyWizardList();
        PolicySetType repositoryPolicySet = this.xacmlPolicyMgmtClient.getPolicySet(this.alias, id);
        String repositoryVersion = repositoryPolicySet.getVersion();
        TypeStringUtils.releaseUnneededMemory(repositoryPolicySet);
        PolicySetType policySet = policySetWizard.getXACML();
        policySet.getPolicyIdReferences().clear();
        policySet.getPolicySetIdReferences().clear();
        policySet.setPolicySetId(id);
        policySet.setVersion(repositoryVersion);
        PolicySetWizard.increaseVersion(policySet);
        this.xacmlPolicyMgmtClient.updatePolicySet(this.alias, repositoryVersion, policySet);
        TypeStringUtils.releaseUnneededMemory(policySetWizard);
        TypeStringUtils.releaseUnneededMemory(policySet);
        int size = policyWizardList.size();
        PolicyType[] policyArray = new PolicyType[size];
        String[] idPrefixArray = new String[size];
        for (int i = 0; i < size; ++i) {
            PolicyWizard policyWizard = policySetWizard.getPolicyWizardList().get(i);
            policyArray[i] = policyWizard.getXACML();
            idPrefixArray[i] = policyWizard.getPolicyIdPrefix();
            TypeStringUtils.releaseUnneededMemory(policyWizard);
        }
        this.xacmlPolicyMgmtClient.addPolicies(this.alias, 0, id, idPrefixArray, policyArray);
        this.highlevelPolicyMgmtClient.purge(this.alias, true, false, false, false);
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws CLIException, ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length != 3) {
            throw new ParseException("Wrong number of arguments.");
        }
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.alias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
        String id = args[1];
        String fileName = args[2];
        File file = new File(fileName);
        if (!file.exists()) {
            System.out.println("Error: file \"" + file.getAbsolutePath() + "\" does not exists.");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        XACMLPolicyCLIUtils.initOpenSAMLAndAttributeWizard();
        List<Object> wizardList = new ArrayList(0);
        try {
            wizardList = this.policyFileEncoder.parse(file);
        }
        catch (EncodingException e) {
            System.out.println("Syntax error in file: " + fileName);
            System.out.println(e.getMessage());
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        if (wizardList.size() == 0) {
            System.out.println("Error: no policies has been defined in file \"" + fileName + "\"");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        if (wizardList.size() > 1) {
            System.out.println("Error: more than one element has been defined in file \"" + fileName + "\"");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        XACMLWizard xacmlWizard = (XACMLWizard)wizardList.get(0);
        int status = xacmlWizard instanceof PolicySetWizard ? this.updatePolicySet(id, (PolicySetWizard)xacmlWizard) : this.updatePolicy(id, (PolicyWizard)xacmlWizard);
        if (this.verboseMode && status == ServiceCLI.ExitStatus.SUCCESS.ordinal()) {
            System.out.println("Success: policy has been updated.");
        }
        return status;
    }
}

