/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.xacml.utils.PolicyHelper;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.ui.cli.CLIException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.AbstractObligationManagementCommand;
import org.glite.authz.pap.ui.cli.policymanagement.XACMLPolicyCLIUtils;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;

public class RemoveObligation
extends AbstractObligationManagementCommand {
    private static final String[] COMMAND_NAME_VALUES = new String[]{"remove-obligation", "ro"};
    private static final String DESCRIPTION = "Removes the obligation with id <obligationId> from the policy identified by <policyId>.";

    public RemoveObligation() {
        super(COMMAND_NAME_VALUES, "<policyId> <obligationId>", DESCRIPTION, "Note that obligations can be added/removed only from resource and action policies.");
    }

    protected int executeCommand(CommandLine commandLine) throws CLIException, ParseException, RemoteException {
        this.parseCommandLine(commandLine);
        XACMLPolicyCLIUtils.initOpenSAMLAndAttributeWizard();
        if (this.xacmlPolicyMgmtClient.hasPolicySet(this.papAlias, this.policyId)) {
            PolicySetType policySet = this.xacmlPolicyMgmtClient.getPolicySet(this.papAlias, this.policyId);
            if (!PolicySetHelper.hasObligationWithId(policySet, this.obligationId)) {
                System.err.println("Obligation '" + this.obligationId + "' not defined for policy '" + this.policyId + "'.");
                return ServiceCLI.ExitStatus.FAILURE.ordinal();
            }
            if (this.removeObligationFromPolicySet(policySet)) {
                if (!this.updatePolicySet(policySet)) {
                    return ServiceCLI.ExitStatus.FAILURE.ordinal();
                }
                return ServiceCLI.ExitStatus.SUCCESS.ordinal();
            }
            System.err.println("Obligation '" + this.obligationId + "' not defined for policy '" + this.policyId + "'.");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        if (this.xacmlPolicyMgmtClient.hasPolicy(this.papAlias, this.policyId)) {
            PolicyType policy = this.xacmlPolicyMgmtClient.getPolicy(this.papAlias, this.policyId);
            if (!PolicyHelper.hasObligationWithId(policy, this.obligationId)) {
                System.err.println("Obligation '" + this.obligationId + "' not defined for policy '" + this.policyId + "'.");
                return ServiceCLI.ExitStatus.FAILURE.ordinal();
            }
            if (this.removeObligationFromPolicy(policy)) {
                if (!this.updatePolicy(policy)) {
                    return ServiceCLI.ExitStatus.FAILURE.ordinal();
                }
                return ServiceCLI.ExitStatus.SUCCESS.ordinal();
            }
            System.err.println("Obligation '" + this.obligationId + "' not defined for policy '" + this.policyId + "'.");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        System.err.println("No policyset or policy found for the given id '" + this.policyId + "'");
        return ServiceCLI.ExitStatus.FAILURE.ordinal();
    }
}

