/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.ui.cli.CLIException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;

public class Purge
extends PolicyManagementCLI {
    private static String OPT_PURGE_RESOURCES_LONG = "only-resources";
    private static String OPT_PURGE_RESOURCES_DESCRIPTION = "Remove resources with no actions.";
    private static String OPT_PURGE_ACTIONS_LONG = "only-actions";
    private static String OPT_PURGE_ACTIONS_DESCRIPTION = "Remove actions with no rules";
    private static final String[] commandNameValues = new String[]{"purge"};
    private static final String DESCRIPTION = "Remove resources without actions and actions without rules.";
    private static final String USAGE = "[options]";
    private String alias = null;

    public Purge() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_PURGE_RESOURCES_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PURGE_RESOURCES_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_PURGE_ACTIONS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PURGE_ACTIONS_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws CLIException, ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        boolean purgeResources = false;
        boolean purgeActions = false;
        if (commandLine.hasOption(OPT_PURGE_RESOURCES_LONG)) {
            purgeResources = true;
        }
        if (commandLine.hasOption(OPT_PURGE_ACTIONS_LONG)) {
            purgeActions = true;
        }
        if (!purgeResources && !purgeActions) {
            purgeActions = true;
            purgeResources = true;
        }
        if (args.length > 1) {
            throw new ParseException("Wrong number of arguments: no arguments required.");
        }
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.alias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
        if (purgeResources && purgeActions) {
            if (this.verboseMode) {
                System.out.print("Purging actions and resources... ");
            }
            this.highlevelPolicyMgmtClient.purge(this.alias, false, true, false, true);
            if (this.verboseMode) {
                System.out.println("ok.");
            }
        } else if (purgeResources) {
            if (this.verboseMode) {
                System.out.print("Purging resources... ");
            }
            this.highlevelPolicyMgmtClient.purge(this.alias, false, false, false, true);
            if (this.verboseMode) {
                System.out.println("ok.");
            }
        } else if (purgeActions) {
            if (this.verboseMode) {
                System.out.print("Purging actions... ");
            }
            this.highlevelPolicyMgmtClient.purge(this.alias, false, true, false, false);
            if (this.verboseMode) {
                System.out.println("ok.");
            }
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

