/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedPolicySetWizardException;
import org.glite.authz.pap.ui.cli.CLIException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;
import org.glite.authz.pap.ui.cli.policymanagement.XACMLPolicyCLIUtils;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListPolicies
extends PolicyManagementCLI {
    private static final String[] commandNameValues = new String[]{"list-policies", "lp"};
    private static final String DESCRIPTION = "List policies. By default the policies of the default pap are listed unless option --" + OPT_PAPALIAS_LONG + " is specified.";
    private static final Logger log = LoggerFactory.getLogger(ListPolicies.class);
    private static final String USAGE = "[options]";
    private static final String OPT_ACTION_LONG = "action";
    private static final String OPT_ACTION_LONG_DESCRIPTION = "filter by action <arg>";
    private static final String OPT_RESOURCE_LONG = "resource";
    private static final String OPT_RESOURCE_LONG_DESCRIPTION = "filter by resource <arg>";
    private String actionFilter = null;
    private String resourceFilter = null;

    public ListPolicies() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected boolean listPolicies(String papAlias, boolean showIds, boolean showRuleId, boolean xacmlOutput) throws RemoteException {
        boolean foundMatchingPolicies = false;
        PolicySetType[] policySetArray = this.xacmlPolicyMgmtClient.listPolicySets(papAlias);
        if (policySetArray.length == 0) {
            throw new CLIException("Error: the repository seems to be corrupted, no policy sets have been found");
        }
        PolicyType[] policyArray = this.xacmlPolicyMgmtClient.listPolicies(papAlias);
        ArrayList<PolicyWizard> policyWizardList = new ArrayList<PolicyWizard>(policyArray.length);
        for (PolicyType policy : policyArray) {
            String actionValue = PolicyWizard.getActionValue(policy);
            if (this.actionFilter != null && !actionValue.equals(this.actionFilter)) continue;
            PolicyWizard policyWizard = new PolicyWizard(policy);
            policyWizardList.add(policyWizard);
            policyWizard.releaseChildrenDOM();
            policyWizard.releaseDOM();
        }
        policyArray = null;
        PolicySetType localRootPolicySet = policySetArray[0];
        for (String policySetId : PolicySetHelper.getPolicySetIdReferencesValues(localRootPolicySet)) {
            PolicySetType policySet = null;
            for (PolicySetType policySetElem : policySetArray) {
                if (!policySetId.equals(policySetElem.getPolicySetId())) continue;
                policySet = policySetElem;
                break;
            }
            if (policySet == null) {
                throw new CLIException("Error: the repository seems to be corrupted, policy set not found: " + policySetId);
            }
            try {
                String targetResourceValue = PolicySetWizard.getResourceValue(policySet);
                if (this.resourceFilter != null && !targetResourceValue.equals(this.resourceFilter) || policyWizardList.isEmpty()) continue;
                PolicySetWizard policySetWizard = new PolicySetWizard(policySet, policyWizardList, null);
                System.out.println();
                if (xacmlOutput) {
                    System.out.println(policySetWizard.toXACMLString());
                } else {
                    System.out.println(policySetWizard.toFormattedString(showIds, showRuleId));
                }
            }
            catch (UnsupportedPolicySetWizardException e) {
                log.error("Unsupported Policy/PolicySet", (Throwable)e);
                System.out.println("id=" + policySetId + ": " + "Generic XACML policy, to see this policy specify the option --show-xacml.");
            }
            foundMatchingPolicies = true;
        }
        return foundMatchingPolicies;
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"use pure XACML (do not convert policies into the simplified policy notation)");
        OptionBuilder.withLongOpt((String)"show-xacml");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Show resource and action ids");
        OptionBuilder.withLongOpt((String)"show-ra-ids");
        options.addOption(OptionBuilder.create((String)"srai"));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Show all ids (resource, action and rule ids)");
        OptionBuilder.withLongOpt((String)"show-all-ids");
        options.addOption(OptionBuilder.create((String)"sai"));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_ALLPAPS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_ALL_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_ACTION_LONG_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_ACTION_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_RESOURCE_LONG_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_RESOURCE_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        boolean xacmlOutput = false;
        boolean showIds = false;
        boolean showRulesId = false;
        if (commandLine.hasOption("show-xacml")) {
            xacmlOutput = true;
        }
        if (commandLine.hasOption("srai")) {
            showIds = true;
        }
        if (commandLine.hasOption("show-all-ids")) {
            showRulesId = true;
            showIds = true;
        }
        if (commandLine.hasOption(OPT_ACTION_LONG)) {
            this.actionFilter = commandLine.getOptionValue(OPT_ACTION_LONG);
        }
        if (commandLine.hasOption(OPT_RESOURCE_LONG)) {
            this.resourceFilter = commandLine.getOptionValue(OPT_RESOURCE_LONG);
        }
        String[] papAliasArray = null;
        String[] papInfoArray = null;
        if (commandLine.hasOption(OPT_ALL_LONG)) {
            Pap[] papArray = this.papMgmtClient.getAllPaps();
            papAliasArray = new String[papArray.length];
            for (int i = 0; i < papArray.length; ++i) {
                papAliasArray[i] = papArray[i].getAlias();
            }
            papInfoArray = this.getPAPInfoArray(papAliasArray, papArray);
        } else if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            papAliasArray = commandLine.getOptionValues(OPT_PAPALIAS_LONG);
            papInfoArray = this.getPAPInfoArray(papAliasArray, null);
        } else {
            Pap pap = Pap.makeDefaultPAP();
            Pap[] papArray = new Pap[]{pap};
            papAliasArray = new String[]{pap.getAlias()};
            papInfoArray = this.getPAPInfoArray(papAliasArray, papArray);
        }
        XACMLPolicyCLIUtils.initOpenSAMLAndAttributeWizard();
        for (int i = 0; i < papAliasArray.length; ++i) {
            System.out.println();
            System.out.println(papInfoArray[i]);
            boolean policiesFound = this.listPolicies(papAliasArray[i], showIds, showRulesId, xacmlOutput);
            if (policiesFound) continue;
            this.printOutputMessage("No policies has been found.");
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }

    private String[] getPAPInfoArray(String[] papAliasArray, Pap[] papArray) throws RemoteException {
        int size = papAliasArray.length;
        String[] papInfoArray = new String[size];
        for (int i = 0; i < size; ++i) {
            String alias = papAliasArray[i];
            Pap pap = papArray != null ? papArray[i] : this.papMgmtClient.getPap(alias);
            papInfoArray[i] = pap.isLocal() ? String.format("%s (local):", pap.getAlias()) : String.format("%s (%s:%s):", pap.getAlias(), pap.getHostname(), pap.getPort());
        }
        return papInfoArray;
    }
}

