/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.xacml.utils.ObligationsHelper;
import org.glite.authz.pap.common.xacml.wizard.ObligationWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;

public abstract class AbstractObligationManagementCommand
extends PolicyManagementCLI {
    protected static final String LONG_DESCRIPTION = "Note that obligations can be added/removed only from resource and action policies.";
    protected static final String USAGE = "<policyId> <obligationId>";
    protected String papAlias = null;
    protected String policyId = null;
    protected String obligationId = null;

    public AbstractObligationManagementCommand(String[] commandNameValues, String usage, String description, String longDescription) {
        super(commandNameValues, usage, description, longDescription);
    }

    protected void parseCommandLine(CommandLine commandLine) throws ParseException {
        String[] args = commandLine.getArgs();
        if (args.length < 3) {
            throw new ParseException("Wrong number of arguments. Usage: <policyId> <obligationId>");
        }
        this.policyId = args[1];
        this.obligationId = args[2];
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.papAlias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
    }

    protected void addObligationToPolicy(PolicyType policy) {
        ObligationsType obligations = policy.getObligations();
        if (obligations == null) {
            policy.setObligations(ObligationsHelper.build());
        }
        policy.getObligations().getObligations().add(this.buildObligation());
    }

    protected boolean removeObligations(ObligationsType ob) {
        if (ob == null) {
            return false;
        }
        ObligationType toBeRemoved = null;
        for (ObligationType o : ob.getObligations()) {
            if (!o.getObligationId().equals(this.obligationId)) continue;
            toBeRemoved = o;
            break;
        }
        if (toBeRemoved != null) {
            ob.getObligations().remove(toBeRemoved);
            return true;
        }
        return false;
    }

    protected boolean removeObligationFromPolicy(PolicyType policy) {
        return this.removeObligations(policy.getObligations());
    }

    protected boolean removeObligationFromPolicySet(PolicySetType policySet) {
        return this.removeObligations(policySet.getObligations());
    }

    protected boolean updatePolicy(PolicyType policy) throws RemoteException {
        String oldPolicyVersion = policy.getVersion();
        PolicyWizard.increaseVersion(policy);
        return this.xacmlPolicyMgmtClient.updatePolicy(this.papAlias, oldPolicyVersion, policy);
    }

    protected boolean updatePolicySet(PolicySetType policySet) throws RemoteException {
        String oldPolicySetVersion = policySet.getVersion();
        PolicySetWizard.increaseVersion(policySet);
        return this.xacmlPolicyMgmtClient.updatePolicySet(this.papAlias, oldPolicySetVersion, policySet);
    }

    protected void addObligationToPolicySet(PolicySetType policySet) {
        ObligationsType obligations = policySet.getObligations();
        if (obligations == null) {
            policySet.setObligations(ObligationsHelper.build());
        }
        policySet.getObligations().getObligations().add(this.buildObligation());
    }

    protected ObligationType buildObligation() {
        ObligationWizard owiz = new ObligationWizard(this.obligationId);
        return owiz.getXACML();
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }
}

