/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.papmanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.papmanagement.AddPap;
import org.glite.authz.pap.ui.cli.papmanagement.PAPManagementCLI;

public class UpdatePap
extends PAPManagementCLI {
    private static final String[] commandNameValues = new String[]{"update-pap", "upap"};
    private static final String DESCRIPTION = "Update pap information. The input is the same as for the \"add-pap\" command, the effect is to update old information with the new one.\n<alias> is a friendly name (it has to be unique) used to identify the pap\n<endpoint> endpoint of the PAP in the following format: [<protocol>://]<host>[:<port>[/path]]\n<dn> DN of the endpoint machine";
    private static final String LOPT_PRIVATE = "private";
    private static final String LOPT_PUBLIC = "public";
    private static final String USAGE = "[options] <alias> [<endpoint> <dn>]";

    public UpdatePap() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Set the remote pap as public (allow to distribute its policies)");
        OptionBuilder.withLongOpt((String)LOPT_PUBLIC);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Set the remote pap as private (default)");
        OptionBuilder.withLongOpt((String)LOPT_PRIVATE);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_LOCAL_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_LOCAL_LONG);
        options.addOption(OptionBuilder.create((String)OPT_LOCAL));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_REMOTE_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_REMOTEL_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_NO_POLICIES_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_NO_POLICIES_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length != 4 && args.length != 2) {
            throw new ParseException("Wrong number of arguments");
        }
        boolean isPublic = false;
        boolean isLocal = args.length == 2;
        if (commandLine.hasOption(OPT_LOCAL)) {
            isLocal = true;
        }
        if (commandLine.hasOption(OPT_REMOTEL_LONG)) {
            isLocal = true;
        }
        if (commandLine.hasOption(LOPT_PUBLIC)) {
            isPublic = true;
        }
        String alias = args[1];
        String protocol = null;
        String dn = null;
        String host = null;
        String port = null;
        String path = null;
        if (args.length != 2) {
            protocol = AddPap.getProtocol(args[2]);
            host = AddPap.getHostname(args[2]);
            port = AddPap.getPort(args[2]);
            AddPap.validatePort(port);
            path = AddPap.getPath(args[2]);
            dn = args[3];
        }
        Pap pap = new Pap(alias, isLocal, dn, host, port, path, protocol, isPublic);
        String msg = "Updating PAP: ";
        if (this.verboseMode) {
            System.out.println(msg + pap.toFormattedString(0, msg.length()));
        }
        if (!this.papMgmtClient.exists(pap.getAlias())) {
            System.out.println("PAP doesn't exists.");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        this.papMgmtClient.updatePap(pap);
        if (pap.isRemote() && !commandLine.hasOption(OPT_NO_POLICIES_LONG)) {
            if (this.verboseMode) {
                System.out.print("Retrieving policies... ");
            }
            try {
                this.papMgmtClient.refreshCache(pap.getAlias());
            }
            catch (RemoteException e) {
                System.out.println("Error: pap information successfully updated but cannot retrieve policies.");
                throw e;
            }
            if (this.verboseMode) {
                System.out.println("ok.");
            }
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

