/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.papmanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.papmanagement.PAPManagementCLI;

public class RemovePap
extends PAPManagementCLI {
    private static final String[] commandNameValues = new String[]{"remove-pap", "rpap"};
    private static final String DESCRIPTION = "Remove a pap and delete its policies.";
    private static final String USAGE = "<alias>";

    public RemovePap() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        return null;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new ParseException("Wrong number of arguments");
        }
        String papId = args[1];
        if (!this.papMgmtClient.exists(papId)) {
            System.out.println("PAP not found: " + papId);
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        this.papMgmtClient.removePap(papId);
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

