/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.papmanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.papmanagement.PAPManagementCLI;

public class ListPaps
extends PAPManagementCLI {
    private static final String[] commandNameValues = new String[]{"list-paps", "lpaps"};
    private static final String DESCRIPTION = "List all defined paps.";
    private static final String OPT_LONGLIST_FORMAT = "l";
    private static final String OPT_LONGLIST_FORMAT_DESCRIPTION = "Use a long list format (displays all the information of a pap).";
    private static final String USAGE = "[options]";

    public ListPaps() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_LONGLIST_FORMAT_DESCRIPTION);
        options.addOption(OptionBuilder.create((String)OPT_LONGLIST_FORMAT));
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        Pap[] papArray;
        boolean logListFormat = false;
        if (commandLine.hasOption(OPT_LONGLIST_FORMAT)) {
            logListFormat = true;
        }
        if ((papArray = this.papMgmtClient.getAllPaps()).length == 0) {
            System.out.println("No remote PAPs has been found.");
            return ServiceCLI.ExitStatus.SUCCESS.ordinal();
        }
        for (Pap pap : papArray) {
            if (logListFormat) {
                System.out.println(pap.toFormattedString());
                continue;
            }
            String visibility = pap.isVisibilityPublic() ? "public" : "private";
            String enabledString = pap.isEnabled() ? "enabled" : "disabled";
            if (pap.isLocal()) {
                System.out.println(String.format("alias = %s (%s, %s, %s)", pap.getAlias(), pap.getTypeAsString(), enabledString, visibility));
                continue;
            }
            System.out.println(String.format("alias = %s (%s, %s, %s, %s)", pap.getAlias(), pap.getTypeAsString(), enabledString, visibility, pap.getEndpoint()));
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

