/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.papmanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.papmanagement.PAPManagementCLI;

public class AddPap
extends PAPManagementCLI {
    private static final String[] commandNameValues = new String[]{"add-pap", "apap"};
    private static final String DESCRIPTION = "Add a remote or local pap.\n<alias> is a friendly name (it has to be unique) used to identify the pap\n<endpoint> endpoint of the PAP in the following format: [<protocol>://]<host>[:<port>[/path]]\n<dn> DN of the endpoint machine";
    private static final String LONG_DESCRIPTION = "A new added pap is disabled by default (i.e. its policies are not sent to the PDP). Use the command \"enable-pap\" to enable a pap. Policies are fetched immediately unless option --" + OPT_NO_POLICIES_LONG + " is given. \nDefault protocol is: " + "https" + "\nDefault port is: " + "8150" + "\nDefault path is: " + "/pap/services/" + "\nExample:\n\t pap-admin " + commandNameValues[0] + " cnaf_pap test.cnaf.infn.it \"/C=IT/O=INFN/OU=Host/L=CNAF/CN=test.cnaf.infn.it\"";
    private static final String LOPT_PRIVATE = "private";
    private static final String LOPT_PUBLIC = "public";
    private static final String USAGE = "[options] <alias> [<endpoint> <dn>]";

    public AddPap() {
        super(commandNameValues, USAGE, DESCRIPTION, LONG_DESCRIPTION);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Set the pap as public (allow to distribute its policies)");
        OptionBuilder.withLongOpt((String)LOPT_PUBLIC);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Set the pap as private (default)");
        OptionBuilder.withLongOpt((String)LOPT_PRIVATE);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_LOCAL_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_LOCAL_LONG);
        options.addOption(OptionBuilder.create((String)OPT_LOCAL));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_REMOTE_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_REMOTEL_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_NO_POLICIES_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_NO_POLICIES_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length != 4 && args.length != 2) {
            throw new ParseException("Wrong number of arguments");
        }
        boolean isPublic = false;
        boolean isLocal = args.length == 2;
        if (commandLine.hasOption(OPT_LOCAL)) {
            isLocal = true;
        }
        if (commandLine.hasOption(OPT_REMOTEL_LONG)) {
            isLocal = false;
        }
        if (commandLine.hasOption(LOPT_PUBLIC)) {
            isPublic = true;
        }
        String alias = args[1];
        String protocol = null;
        String dn = null;
        String host = null;
        String port = null;
        String path = null;
        if (args.length != 2) {
            protocol = AddPap.getProtocol(args[2]);
            host = AddPap.getHostname(args[2]);
            port = AddPap.getPort(args[2]);
            AddPap.validatePort(port);
            path = AddPap.getPath(args[2]);
            dn = args[3];
        }
        Pap pap = new Pap(alias, isLocal, dn, host, port, path, protocol, isPublic);
        String msg = "Adding pap: ";
        if (this.verboseMode) {
            System.out.println(msg + pap.toFormattedString(0, msg.length()));
        }
        if (this.papMgmtClient.exists(pap.getAlias())) {
            System.out.println("pap already exists.");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        this.papMgmtClient.addPap(pap);
        if (pap.isRemote() && !commandLine.hasOption(OPT_NO_POLICIES_LONG)) {
            if (this.verboseMode) {
                System.out.print("Retrieving policies... ");
            }
            try {
                this.papMgmtClient.refreshCache(pap.getAlias());
            }
            catch (RemoteException e) {
                System.out.println("Error: pap successfully added but cannot retrieve policies.");
                throw e;
            }
            if (this.verboseMode) {
                System.out.println("ok.");
            }
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }

    protected static String getHostname(String endpoint) {
        String hostname;
        int start = endpoint.indexOf("://");
        start = start == -1 ? 0 : (start += 3);
        int end = endpoint.indexOf(58, start);
        if (end == -1) {
            end = endpoint.length();
        }
        if ((hostname = endpoint.substring(start, end)).length() == 0) {
            return null;
        }
        return hostname;
    }

    protected static String getPath(String endpoint) {
        int start = endpoint.indexOf("://");
        start = start == -1 ? 0 : (start += 3);
        start = endpoint.indexOf(47, start);
        if (start == -1) {
            return null;
        }
        int end = endpoint.length();
        return endpoint.substring(start, end);
    }

    protected static String getPort(String endpoint) {
        int start = endpoint.indexOf("://");
        start = start == -1 ? 0 : (start += 3);
        start = endpoint.indexOf(58, start);
        int end = endpoint.indexOf(47, start);
        if (start == -1) {
            return null;
        }
        ++start;
        if (end == -1) {
            end = endpoint.length();
        }
        return endpoint.substring(start, end);
    }

    protected static String getProtocol(String endpoint) {
        int index = endpoint.indexOf("://");
        if (index == -1) {
            return null;
        }
        String protocol = endpoint.substring(0, index);
        if (protocol.length() == 0) {
            return null;
        }
        return protocol;
    }

    protected static void validatePort(String port) throws ParseException {
        if (port != null) {
            int portNum;
            try {
                portNum = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid port number: " + port);
            }
            if (portNum > 65535) {
                throw new ParseException("Invalid port number: " + port);
            }
        }
    }
}

