/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.authzmanagement;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import org.apache.commons.lang.StringUtils;
import org.glite.authz.pap.common.exceptions.PAPException;
import org.glite.authz.pap.common.exceptions.VOMSSyntaxException;
import org.glite.authz.pap.common.utils.PathNamingScheme;
import org.glite.authz.pap.services.authz_management.axis_skeletons.PAPPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzCLIUtils {
    public static final String ANY_AUTHENTICATED_USER_DN = "/O=PAP/OU=Internal/CN=Any authenticated user";
    public static final Logger log = LoggerFactory.getLogger(AuthzCLIUtils.class);

    public static String convertX500SubjectToRFC2253(String x500Subject) {
        try {
            return OpensslNameUtils.opensslToRfc2253((String)x500Subject);
        }
        catch (IllegalArgumentException e) {
            throw new PAPException("The string passed as argument is not a valid certificate subject!", e);
        }
    }

    public static String convertRFC2253toX500Subject(String rfc2253Subject) {
        try {
            return OpensslNameUtils.convertFromRfc2253((String)rfc2253Subject, (boolean)false);
        }
        catch (IllegalArgumentException e) {
            throw new PAPException("The string passed as argument is not a valid certificate subject!", e);
        }
    }

    public static PAPPrincipal principalFromString(String principalString) {
        PAPPrincipal principal = new PAPPrincipal();
        try {
            PathNamingScheme.checkSyntax(principalString);
            principal.setType("voms-fqan");
            principal.setName(principalString);
        }
        catch (VOMSSyntaxException e) {
            principal.setType("x509-dn");
            if (principalString.equals("ANYONE")) {
                principal.setName(ANY_AUTHENTICATED_USER_DN);
            }
            principal.setName(AuthzCLIUtils.convertRFC2253toX500Subject(principalString));
        }
        return principal;
    }

    public static String[] permissionsFromString(String permString) {
        Object[] permissions = permString.contains("|") ? permString.split("\\|") : new String[]{permString};
        log.debug("Perms: {}", (Object)StringUtils.join((Object[])permissions, (String)","));
        return permissions;
    }
}

