/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.services;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.glite.authz.pap.authz.ACL;
import org.glite.authz.pap.authz.AuthorizationEngine;
import org.glite.authz.pap.authz.PAPAdmin;
import org.glite.authz.pap.authz.PAPAdminFactory;
import org.glite.authz.pap.authz.PAPContext;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.authz.VOMSFQAN;
import org.glite.authz.pap.authz.X509Principal;
import org.glite.authz.pap.authz.exceptions.PAPAuthzException;
import org.glite.authz.pap.authz.operations.authzmanagement.AddACEOperation;
import org.glite.authz.pap.authz.operations.authzmanagement.GetACLOperation;
import org.glite.authz.pap.authz.operations.authzmanagement.RemoveACEOperation;
import org.glite.authz.pap.authz.operations.authzmanagement.SetACLOperation;
import org.glite.authz.pap.common.utils.PathNamingScheme;
import org.glite.authz.pap.services.authz_management.axis_skeletons.PAPACE;
import org.glite.authz.pap.services.authz_management.axis_skeletons.PAPAuthorizationManagement;
import org.glite.authz.pap.services.authz_management.axis_skeletons.PAPException;
import org.glite.authz.pap.services.authz_management.axis_skeletons.PAPPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAPAuthzManagementService
implements PAPAuthorizationManagement {
    public static final Logger log = LoggerFactory.getLogger(PAPAuthzManagementService.class);

    protected PAPAdmin principalToAdmin(PAPPrincipal principal) {
        if (principal.getType().equals("x509-dn")) {
            return PAPAdminFactory.getDn(principal.getName());
        }
        if (principal.getType().equals("voms-fqan")) {
            return PAPAdminFactory.getFQAN(principal.getName());
        }
        throw new PAPAuthzException("Unsupported principal type '" + principal.getType() + "'.");
    }

    protected void checkPAPPrincipal(PAPPrincipal principal) {
        if (principal == null) {
            throw new PAPAuthzException("Null principal passed as argument!");
        }
        if (principal.getType().equals("x509-dn")) {
            if (principal.getName() == null || principal.getName().equals("")) {
                throw new PAPAuthzException("X509 Principal with NULL or empty DN passed as argument!");
            }
        } else if (principal.getType().equals("voms-fqan")) {
            PathNamingScheme.checkSyntax(principal.getName());
        }
    }

    @Override
    public void addACE(String context, PAPPrincipal principal, String[] permissions) throws RemoteException, PAPException {
        log.info("addACE('{}','{}','{}')", new Object[]{context, principal.getName(), permissions});
        PAPContext papContext = null;
        this.checkPAPPrincipal(principal);
        PAPAdmin admin = this.principalToAdmin(principal);
        if (permissions == null || permissions.length == 0) {
            throw new PAPAuthzException("Cannot set NULL permissions for principal '" + admin + "'.");
        }
        if (context != null && !context.equals("") && !context.equals("global-context")) {
            throw new PAPAuthzException("Only the context 'global-context' is currently supported!");
        }
        papContext = AuthorizationEngine.instance().getGlobalContext();
        PAPPermission perms = PAPPermission.fromStringArray(permissions);
        AddACEOperation.instance(org.glite.authz.pap.authz.PAPACE.instance(papContext, admin, perms)).execute();
        AuthorizationEngine.instance().saveConfiguration();
    }

    @Override
    public void removeACE(String context, PAPPrincipal principal) throws RemoteException, PAPException {
        log.info("removeACE('{}','{}')", (Object)context, (Object)principal.getName());
        PAPContext papContext = null;
        this.checkPAPPrincipal(principal);
        PAPAdmin admin = this.principalToAdmin(principal);
        if (context != null && !context.equals("") && !context.equals("global-context")) {
            throw new PAPAuthzException("Only the context 'global-context' is currently supported!");
        }
        papContext = AuthorizationEngine.instance().getGlobalContext();
        RemoveACEOperation.instance(org.glite.authz.pap.authz.PAPACE.instance(papContext, admin)).execute();
        AuthorizationEngine.instance().saveConfiguration();
    }

    @Override
    public void setACL(String context, PAPACE[] acl) throws RemoteException, PAPException {
        log.info("setACL(" + StringUtils.join((Object[])new Object[]{context, acl}, (char)',') + ");");
        if (context != null && !context.equals("") && !context.equals("global-context")) {
            throw new PAPAuthzException("Only the context 'global-context' is currently supported!");
        }
        PAPContext papContext = AuthorizationEngine.instance().getGlobalContext();
        ACL globalACL = papContext.getAcl();
        SetACLOperation.instance(context, this.convertACL(acl)).execute();
        AuthorizationEngine.instance().saveConfiguration();
    }

    @Override
    public PAPACE[] getACL(String context) throws RemoteException, PAPException {
        log.info("getACL('{}')", (Object)context);
        if (context != null && !context.equals("") && !context.equals("global-context")) {
            throw new PAPAuthzException("Only the context 'global-context' is currently supported!");
        }
        PAPContext papContext = AuthorizationEngine.instance().getGlobalContext();
        Map permissions = (Map)GetACLOperation.instance(context).execute();
        int permsSize = permissions.size();
        if (permsSize == 0) {
            return null;
        }
        PAPACE[] entries = new PAPACE[permsSize];
        int i = 0;
        for (Map.Entry entry : permissions.entrySet()) {
            PAPACE wsEntry = new PAPACE();
            wsEntry.setPrincipal(this.adminToPrincipal((PAPAdmin)entry.getKey()));
            wsEntry.setPermissions(((PAPPermission)entry.getValue()).toStringArray());
            entries[i++] = wsEntry;
        }
        return entries;
    }

    protected PAPACE convertACE(org.glite.authz.pap.authz.PAPACE ace) {
        PAPACE wsACE = new PAPACE();
        wsACE.setPrincipal(this.adminToPrincipal(ace.getAdmin()));
        if (ace.getPerms() == null) {
            wsACE.setPermissions(null);
        } else {
            wsACE.setPermissions(ace.getPerms().toStringArray());
        }
        return wsACE;
    }

    protected PAPPrincipal adminToPrincipal(PAPAdmin admin) {
        PAPPrincipal principal = new PAPPrincipal();
        if (admin instanceof X509Principal) {
            principal.setType("x509-dn");
            principal.setName(admin.getName());
        } else if (admin instanceof VOMSFQAN) {
            principal.setType("voms-fqan");
            principal.setName(admin.getName());
        }
        return principal;
    }

    protected Map<PAPAdmin, PAPPermission> convertACL(PAPACE[] entries) {
        HashMap<PAPAdmin, PAPPermission> permissions = new HashMap<PAPAdmin, PAPPermission>(entries.length);
        for (PAPACE entry : entries) {
            permissions.put(this.principalToAdmin(entry.getPrincipal()), PAPPermission.fromStringArray(entry.getPermissions()));
        }
        return permissions;
    }
}

