/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.server.standalone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glite.authz.pap.monitoring.MonitoringServlet;
import org.glite.authz.pap.server.standalone.PAPShutdownCommand;
import org.glite.authz.pap.server.standalone.ShutdownServlet;
import org.italiangrid.utils.https.JettyRunThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAPShutdownAndStatusService {
    public static void startPAPShutdownAndStatusService(int shutdownPort, List<Runnable> shutdownCommands) {
        Server shutdownService = new Server();
        shutdownService.setSendServerVersion(false);
        shutdownService.setSendDateHeader(false);
        Thread shutdownCommandThread = PAPShutdownAndStatusService.buildServiceShutdownThread(shutdownService, shutdownCommands);
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setHost("localhost");
        connector.setPort(shutdownPort);
        shutdownService.setConnectors(new Connector[]{connector});
        ServletContextHandler servletContext = new ServletContextHandler(0);
        servletContext.setDisplayName("Shutdown Controller");
        ServletHolder shutdownServlet = new ServletHolder((Servlet)new ShutdownServlet(shutdownCommandThread));
        servletContext.addServlet(shutdownServlet, "/shutdown");
        ServletHolder statusServlet = new ServletHolder((Servlet)new MonitoringServlet());
        servletContext.addServlet(statusServlet, "/status");
        JettyRunThread shutdownServiceRunThread = new JettyRunThread(shutdownService);
        shutdownServiceRunThread.start();
        shutdownService.setHandler((Handler)servletContext);
    }

    private static Thread buildServiceShutdownThread(Server shutdownService, List<Runnable> commands) {
        List<PAPShutdownCommand> shutdownCommands;
        PAPShutdownCommand shutdownShutdownServiceCommand = new PAPShutdownCommand(shutdownService);
        if (commands == null || commands.isEmpty()) {
            shutdownCommands = Collections.singletonList(shutdownShutdownServiceCommand);
        } else {
            shutdownCommands = new ArrayList<Runnable>(commands);
            shutdownCommands.add(shutdownShutdownServiceCommand);
        }
        Thread shutdownCommandThread = new Thread(){

            public void run() {
                for (Runnable shutdownCommand : shutdownCommands) {
                    shutdownCommand.run();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownCommandThread));
        return shutdownCommandThread;
    }
}

