/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.server.standalone;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.server.standalone.PAPShutdownAndStatusService;
import org.glite.authz.pap.server.standalone.PAPShutdownCommand;
import org.italiangrid.utils.https.SSLOptions;
import org.italiangrid.utils.https.ServerFactory;
import org.italiangrid.utils.https.impl.canl.CANLListener;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PAPServer {
    private static final String DEFAULT_WAR_LOCATION = System.getProperty("PAP_HOME") + "/wars/pap.war";
    private static final Logger log = LoggerFactory.getLogger(PAPServer.class);
    private static final String CONF_DIR_OPTION_NAME = "conf-dir";
    protected String papConfigurationDir;
    protected Server papServer;
    private WebAppContext webappContext;

    public PAPServer(String[] args) {
        try {
            this.parseOptions(args);
            CertificateUtils.configureSecProvider();
            PAPConfiguration.initialize(this.papConfigurationDir);
            this.configurePAPServer();
            this.papServer.start();
            if (this.webappContext.getUnavailableException() != null) {
                throw this.webappContext.getUnavailableException();
            }
            this.papServer.join();
        }
        catch (Throwable e) {
            log.error("PAP encountered an error that could not be dealt with, shutting down!");
            log.error(e.getMessage());
            System.err.println("PAP encountered an error that could not be dealt with, shutting down!");
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), e);
            }
            try {
                this.papServer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private SSLOptions getSSLOptions() {
        SSLOptions options = new SSLOptions();
        options.setCertificateFile(this.getStringFromSecurityConfiguration("certificate", "/etc/grid-security/hostcert.pem"));
        options.setKeyFile(this.getStringFromSecurityConfiguration("private_key", "/etc/grid-security/hostkey.pem"));
        options.setNeedClientAuth(true);
        options.setWantClientAuth(true);
        options.setTrustStoreDirectory(this.getStringFromSecurityConfiguration("trust_store_dir", String.valueOf("/etc/grid-security/certificates")));
        int trustStoreRefreshInMinutes = this.getIntFromStandaloneConfiguration("crl_update_interval", 10);
        long trustStoreUpdatePeriod = TimeUnit.MINUTES.toMillis(trustStoreRefreshInMinutes);
        options.setTrustStoreRefreshIntervalInMsec(trustStoreUpdatePeriod);
        return options;
    }

    private void configurePAPServer() {
        log.info("Configuring jetty PAP server...");
        int port = this.getIntFromStandaloneConfiguration("port", 8150);
        String host = this.getStringFromStandaloneConfiguration("hostname", "localhost");
        SSLOptions options = this.getSSLOptions();
        CANLListener l = new CANLListener();
        X509CertChainValidatorExt validator = CertificateValidatorBuilder.buildCertificateValidator((String)options.getTrustStoreDirectory(), (ValidationErrorListener)l, (StoreUpdateListener)l, (long)options.getTrustStoreRefreshIntervalInMsec());
        PAPConfiguration.instance().setCertChainValidator(validator);
        int maxRequestQueueSize = this.getIntFromStandaloneConfiguration("max_request_queue_size", -1);
        log.debug("maxRequestQueueSize = {}", (Object)maxRequestQueueSize);
        int maxConnections = this.getIntFromStandaloneConfiguration("max_connections", 64);
        if (maxConnections <= 0) {
            log.error("Please specify a positive value for the 'maxConnections' configuration parameter!");
            log.error("Will use the hardcoded default '{}' instead...", (Object)64);
            maxConnections = 64;
        }
        log.info("maxConnections = {}", (Object)maxConnections);
        this.papServer = ServerFactory.newServer((String)host, (int)port, (SSLOptions)options, (X509CertChainValidatorExt)validator, (int)maxConnections, (int)maxRequestQueueSize);
        PAPShutdownCommand papShutdownCommand = new PAPShutdownCommand(this.papServer);
        PAPShutdownAndStatusService.startPAPShutdownAndStatusService(8151, Collections.singletonList(papShutdownCommand));
        log.info("Loading war from: {}", (Object)DEFAULT_WAR_LOCATION);
        this.webappContext = new WebAppContext();
        this.webappContext.setContextPath("/pap");
        this.webappContext.setWar(DEFAULT_WAR_LOCATION);
        this.webappContext.setParentLoaderPriority(true);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.webappContext, new DefaultHandler()});
        this.papServer.setHandler((Handler)handlers);
    }

    private int getIntFromStandaloneConfiguration(String key, int defaultValue) {
        PAPConfiguration conf = PAPConfiguration.instance();
        return conf.getInt("standalone-service." + key, defaultValue);
    }

    private String getStringFromSecurityConfiguration(String key, String defaultValue) {
        PAPConfiguration conf = PAPConfiguration.instance();
        return conf.getString("security." + key, defaultValue);
    }

    private String getStringFromStandaloneConfiguration(String key, String defaultValue) {
        PAPConfiguration conf = PAPConfiguration.instance();
        return conf.getString("standalone-service." + key, defaultValue);
    }

    protected void parseOptions(String[] args) {
        if (args.length > 0) {
            int currentArg = 0;
            while (currentArg < args.length) {
                if (!args[currentArg].startsWith("--")) {
                    this.usage();
                    continue;
                }
                if (args[currentArg].equalsIgnoreCase("--conf-dir")) {
                    this.papConfigurationDir = args[currentArg + 1];
                    log.info("Starting PAP with configuration dir: {}", (Object)this.papConfigurationDir);
                    currentArg += 2;
                    continue;
                }
                this.usage();
            }
        }
    }

    private void usage() {
        String usage = "PAPServer [--conf-dir <confDir>]";
        System.out.println(usage);
        System.exit(1);
    }

    public static void main(String[] args) {
        new PAPServer(args);
    }

    final class PAPStandaloneServiceDefaults {
        static final String HOSTNAME = "localhost";
        static final int PORT = 8150;
        static final int SHUTDOWN_PORT = 8151;
        static final int MAX_REQUEST_QUEUE_SIZE = -1;
        static final int MAX_CONNECTIONS = 64;
        static final String CERTIFICATE_PATH = "/etc/grid-security/hostcert.pem";
        static final String PRIVATE_KEY_PATH = "/etc/grid-security/hostkey.pem";
        static final String CA_PATH = "/etc/grid-security/certificates";
        static final boolean CRL_ENABLED = true;
        static final int TRUST_STORE_REFRESH_PERIOD_IN_MINUTES = 10;
        static final String TRUST_STORE_DIR = "/etc/grid-security/certificates";

        PAPStandaloneServiceDefaults() {
        }
    }
}

