/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.repository.dao.filesystem;

import java.io.File;
import java.io.IOException;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.repository.RepositoryManager;
import org.glite.authz.pap.repository.dao.filesystem.FileSystemPapDAO;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRepositoryManager
extends RepositoryManager {
    protected static final String POLICY_FILENAME_PREFIX = "Policy_";
    protected static final String POLICYSET_FILENAME_PREFIX = "PolicySet_";
    protected static final String XACML_FILENAME_EXTENSION = ".xml";
    private static final Logger log = LoggerFactory.getLogger(FileSystemRepositoryManager.class);
    private static String fileSystemDatabaseDir;
    private static boolean initialized;
    private static FileSystemRepositoryManager instance;

    private FileSystemRepositoryManager() {
    }

    public static String getFileNameExt() {
        return XACML_FILENAME_EXTENSION;
    }

    public static String getFileSystemDatabaseDir() {
        return fileSystemDatabaseDir;
    }

    public static FileSystemRepositoryManager getInstance() {
        if (instance == null) {
            instance = new FileSystemRepositoryManager();
        }
        return instance;
    }

    public static String getPAPDirAbsolutePath(String papId) {
        return fileSystemDatabaseDir + File.separator + papId + File.separator;
    }

    public static String getPolicyFileNamePrefix() {
        return POLICY_FILENAME_PREFIX;
    }

    public static String getPolicySetFileNamePrefix() {
        return POLICYSET_FILENAME_PREFIX;
    }

    public static String getXACMLFileNameExtension() {
        return XACML_FILENAME_EXTENSION;
    }

    private static void setupRepositoryDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            FileSystemRepositoryManager.setupRepositoryDirectory(dir.getParentFile());
        }
        if (!dir.canRead()) {
            throw new RepositoryException("Read permission not set: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new RepositoryException("Write permission not set: " + dir.getAbsolutePath());
        }
        try {
            File tempFile = new File(dir.getAbsoluteFile() + File.separator + "delete_me.tmp");
            tempFile.createNewFile();
            tempFile.delete();
        }
        catch (IOException e) {
            throw new RepositoryException("Execute permission not set: " + dir.getAbsolutePath(), e);
        }
    }

    public String getRepositoryVersion() {
        if (!initialized) {
            throw new RepositoryException("FileSytemRepository not initialized");
        }
        return FileSystemPapDAO.getInstance().getVersion();
    }

    public void initialize() {
        log.info("Initializing filesystem repository...");
        fileSystemDatabaseDir = PAPConfiguration.instance().getPAPRepositoryDir();
        File rootDir = new File(fileSystemDatabaseDir);
        try {
            FileSystemRepositoryManager.setupRepositoryDirectory(rootDir);
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Cannot create the repository root directory: " + rootDir.getAbsolutePath(), e);
        }
        initialized = true;
        log.info("Repository root directory is set to: " + rootDir.getAbsolutePath());
    }

    static {
        initialized = false;
        instance = null;
    }
}

